#include <iostream>
#include <string>
#include <list>
#include <vector>
#include <algorithm>
#include <iterator>
#include "utils.h" // dla funkcji printContainer(): por. receptur 7.10

using namespace std;

int main( ) {

   vector<string> v1, v2, v3;

   v1.push_back("a");
   v1.push_back("c");
   v1.push_back("e");

   v2.push_back("b");
   v2.push_back("d");
   v2.push_back("f");

   v3.reserve(v1.size( ) + v2.size( ) + 1);

   // stosowanie back_inserter pozwala na unikanie koniecznoci wstawiania
   // do kontenera zestawu obiektw domylnych; nie oznacza to jednak, e
   // nie trzeba stosowa reserve!
   merge(v1.begin( ), v1.end( ),
         v2.begin( ), v2.end( ),
         back_inserter<vector<string> >(v3));

   printContainer(v3);

   // odrobina baaganu
   random_shuffle(v3.begin( ), v3.end( ));
   sort(v3.begin( ), v3.begin( ) + v3.size( ) / 2);
   sort(v3.begin( ) + v3.size( ) / 2, v3.end( ));

   printContainer(v3);

   inplace_merge(v3.begin( ), v3.begin( ) + 3, v3.end( ));

   printContainer(v3);

   // w przypadku scalania dwch list naley zastosowa list::merge.
   list<string> lstStr1, lstStr2;

   lstStr1.push_back("Franek");
   lstStr1.push_back("Kimono");
   lstStr1.push_back("Tolek");
   lstStr1.push_back("Banan");

   lstStr2.push_back("Allie");
   lstStr2.push_back("McBeal");
   lstStr2.push_back("Szczwany");
   lstStr2.push_back("Lis");

   lstStr1.sort( );  // bez posortowania scalanie narobi baaganu!
   lstStr2.sort( );

   lstStr1.merge(lstStr2); // dziaa tylko z inn list tego samego typu

   printContainer(lstStr1);
}
