# nazwy plikw rdowych, zada, katalogw kompilacji
#  i katalogu instalacyjnego
SOURCES = hellobeatles.cpp
OUTPUTFILE = hellobeatles
LIBJOHNPAUL = libjohnpaul.a
LIBGEORGERINGO = libgeorgeringo.so
JOHNPAULDIR = ../johnpaul
GEORGERINGODIR = ../georgeringo
INSTALLDIR = ../binaries

#
# Uzupenienie cieki przeszukiwania plikw nagwkowych o katalog nadrzdny
#
CPPFLAGS	+= -I..

#
# Zadanie domylne
#
.PHONY: all
all: $(HELLOBEATLES)

#
# Zadanie kompilacji pliku wykonywalnego.
#
$(OUTPUTFILE): $(subst .cpp,.o,$(SOURCES)) \
		$(JOHNPAULDIR)/$(LIBJOHNPAUL) \
		$(GEORGERINGODIR)/$(LIBGEORGERINGO)
	$(CXX) $(LDFLAGS) -o $@ $^

.PHONY: install
install:
	mkdir -p $(INSTALLDIR)
	cp -p $(OUTPUTFILE) $(INSTALLDIR)

.PHONY: clean
clean:
	rm -f *.o
	rm -f $(OUTPUTFILE)

# Generowanie zalenoci plikw .ccp od plikw .hpp
include $(subst .cpp,.d,$(SOURCES))

%.d: %.cpp
	$(CC) -M $(CPPFLAGS) $< > $@.$$$$; \
	sed 's,\($*\)\.o[ :]*,\1.o $@ : ,g' < $@.$$$$ > $@; \
	rm -f $@.$$$$