#include <exception>
#include <iostream>     // cout
#include <stdexcept>    // runtime_error
#include <xercesc/dom/DOM.hpp>
#include <xercesc/parsers/XercesDOMParser.hpp>
#include <xercesc/sax/HandlerBase.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include "xerces_strings.hpp"  // listing 14.4

using namespace std;
using namespace xercesc;

/*
 * definicja klasy XercesInitializer jak na listingu 14.8
 * i klasy CircusErrorHandler jak na listingu 14.7
 */

int main( )
{
    try {
        // inicjalizacja infrastruktury Xerces i konstrukcja parsera DOM
        XercesInitializer        init;
        XercesDOMParser          parser;

        // wczenie walidacji DTD
        parser.setValidationScheme(XercesDOMParser::Val_Always);

        // rejestracja obsugi bdw do odbioru 
        // powiadomie o naruszeniach DTD 
        CircusErrorHandler       handler;
        parser.setErrorHandler(&handler);

        // analiza i walidacja
        parser.parse("cyrk.xml");
    } catch (const SAXException& e) {
        cout << "bd xml: " << toNative(e.getMessage( )) << "\n";
        return EXIT_FAILURE;
    } catch (const XMLException& e) {
        cout << "bd xml: " << toNative(e.getMessage( )) << "\n";
        return EXIT_FAILURE;
    } catch (const exception& e) {
        cout << e.what( ) << "\n";
        return EXIT_FAILURE;
    }
}