// implementuje wywoania zwrotne odbierajce dane tekstowe
// i powiadomienia o pocztkach i kocach elementw
class CircusContentHandler : public DefaultHandler {
public:
    CircusContentHandler(vector<Animal>& animalList) 
        : animalList_(animalList),   // lista do wypenienia
          parsingAnimalList_(false), // stan przetwarzania
          parsingAnimal_(false),     // stan przetwarzania
          parsingAnimalChild_(false) // stan przetwarzania
        { }

    // odbiera powiadomienia parsera o napotkaniu 
    // znacznika otwierajcego element
    void startElement( 
             const XMLCh *const uri,       // URI przestrzeni nazw
             const XMLCh *const localname, // prosta nazwa znacznika
             const XMLCh *const qname,     // kwalifikowana nazwa znacznika
             const Attributes &attrs )     // zestaw atrybutw
    {
        static XercesString animalList = fromNative("animalList");
        static XercesString animal = fromNative("animal");
        static XercesString xmlns = 
            fromNative("http://www.feldman-family-circus.com");

        // sprawdzenie URI przestrzeni nazw
        if (uri != xmlns)
            throw runtime_error(
                      string("niepoprawny URI przestrzeni nazw: ") + toNative(uri)
                  );

        // (i) aktualizacja znacznikw parsingAnimalList_, parsingAnimal_ 
        //     i parsingAnimalChild_, sygnalizujcych pooenie parsera w
        //     dokumencie
        // (ii) sprawdzanie poprawnoci zagniedania elementw
        //
        // (iii) oddelegowanie waciwych zada do metody startAnimalChild()
        if (!parsingAnimalList_) { 
            // wanie napotkalimy element gwny dokumentu
            if (localname == animalList) {     
                parsingAnimalList_ = true; // aktualizacja stanu przetwarzania
            } else {
                // niepoprawne zagniedenie
                throw runtime_error(
                          string("oczekiwany 'animalList', znaleziony ") + 
                          toNative(localname )
                      );
            }
        } else if (!parsingAnimal_) {
            // wanie napotkalimy element "animal"
            if (localname == animal) {
                parsingAnimal_ = true;           // aktualizacja stanu przetwarzania
                animalList_.push_back(Animal( )); // dodanie obiektu Animal do listy
            } else {
                // niepoprawne zagniedenie
                throw runtime_error(
                          string("oczekiwany 'animal', znaleziony ") + 
                          toNative(localname )
                      );
            }
        } else {
            // We're in the middle of parsing an animal element.
            if (parsingAnimalChild_) {
                // niepoprawne zagniedenie
                throw runtime_error("niepoprawny element \"animal\""); 
            } 
            // aktualizacja stanu przetwarzania
            parsingAnimalChild_ = true; 

            // czarn robot skadamy na startAnimalChild()
            startAnimalChild(uri, localname, qname, attrs); 
        }
    }

    
    void endElement( 
             const XMLCh *const uri,       // URI przestrzeni nazw
             const XMLCh *const localname, // prosta nazwa znacznika
             const XMLCh *const qname )    // kwalifikowana nazwa znacznika
    {
        static XercesString animalList = fromNative("animal-list");
        static XercesString animal = fromNative("animal");

        // aktualizacja znacznikw parsingAnimalList, parsingAnimal_
        // i parsingAnimalChild_; oddelegowanie waciwych zada obsugi
        // do metody endAnimalChild()
        if (localname == animal) {
            parsingAnimal_ = false;
        } else if (localname == animalList) {
            parsingAnimalList_ = false;
        } else {
            endAnimalChild(uri, localname, qname);
            parsingAnimalChild_ = false;
        }
    }

    // odbiera powiadomienia o danych znakowych
    void characters(const XMLCh* const chars, const unsigned int length) 
    {
        // doczanie znakw do skadowej currentText_ celem pniejszego
        // przetworzenia w metodzie endAnimalChild( )
        currentText_.append(chars, length);
    }
private:
    // jeli biecy element reprezentuje opiekuna albo tresera,
    // jego atrybuty posu do konstruowania obiektu Contact dla
    // biecego obiektu Animal; w innych przypadkach czycimy currentText_
    // przygotowujc si do wywoania zwrotnego characters()
    void startAnimalChild(
             const XMLCh *const uri,       // URI przestrzeni nazw
             const XMLCh *const localname, // prosta nazwa znacznika
             const XMLCh *const qname,     // kwalifikowana nazwa znacznika
             const Attributes &attrs )     // zestaw atrybutw
    {
        static XercesString vet = fromNative("veterinarian");
        static XercesString trainer = fromNative("trainer");

        Animal& animal = animalList_.back( );
        if (localname == vet) {
            // napotkalimy element "veterinarian"
            animal.setVeterinarian(contactFromAttributes(attrs));
        } else if (localname == trainer) {
            // napotkalimy element "trainer"
            animal.setTrainer(contactFromAttributes(attrs));
        } else {
            // napotkalimy element "name", "species" albo
            // "dateOfBirth"; jego zawarto bdzie dostarczona
            // wywoaniem zwrotnym metody characters().
            currentText_.clear( );
        }
    }

    // jeli biecy element reprezentuje imi, gatunek albo dat urodzenia
    // zwierzaka, ustawiamy odpowiednie skadowe obiektu Animal zgodnie z 
    // zawartoci currentText_
    void endAnimalChild(
             const XMLCh *const uri,       // URI przestrzeni nazw
             const XMLCh *const localname, // prosta nazwa znacznika elementu
             const XMLCh *const qname )    // kwalifikowana nazwa znacznika elementu
    {
        static XercesString name = fromNative("name");
        static XercesString species = fromNative("species");
        static XercesString dob = fromNative("dateOfBirth");

        // currentText_ zawiera dane tekstowe koczcego si elementu;
        // wykorzystamy go do ustawienia skadowych obiektu biecego
        // zwierzaka
        if (localname == name) {
            animal.setName(toNative(currentText_));
        } else if (localname == species) {
            animal.setSpecies(toNative(currentText_));
        } else if (localname == dob) {
            animal.setDateOfBirth(toNative(currentText_));
        } 
    }

    vector<Animal>&  animalList_;         // lista do wypenienia
    bool             parsingAnimalList_;  // stan przetwarzania
    bool             parsingAnimal_;      // stan przetwarzania
    bool             parsingAnimalChild_; // stan przetwarzania
    XercesString     currentText_;        // dane znakowe biecego elementu
};