#include <iostream>
#include <ctime>
#include <locale>
#include <sstream>
#include <iterator>

using namespace std;

void translateDate(istream& in, ostream& out) {

   // utworzenie "czytnika" dat
   const time_get<char>& dateReader =
     use_facet<time_get<char> >(in.getloc( ));

   // utworzenie obiektu stanu, wykorzystywanego przez
   // aspekty do sygnalizowania ewentualnych problemw
   ios_base::iostate state = 0;

   // znacznik koca
   istreambuf_iterator<char> end;

   tm t; // struktura reprezentujca czas (z <ctime>)

   // wczytanie daty ze strumienia wejciowego i
   // zapisanie jej w strukturze tm
   dateReader.get_date(in, end, in, state, &t);

   // mamy ju dat w strukturze tm; wypiszemy j do strumienia wyjciowego
   // z uyciem jego schematu lokalizacji; przed wypisaniem warto sprawdzi
   // poprawno wartoci daty
   if (state == 0 || state == ios_base::eofbit) {
      // odczyt udany
      const time_put<char>& dateWriter =
        use_facet<time_put<char> >(out.getloc( ));

      char fmt[] = "%x";

      if (dateWriter.put(out, out, out.fill( ),
                         &t, &fmt[0], &fmt[2]).failed( ))
         cerr << "Nie mona zapisa do strumienia wyjciowego.\n";
   } else {
      cerr << "Nie mona odczyta wartoci z cin!\n";
   }
}

int main( ) {

   cin.imbue(locale("english"));
   cout.imbue(locale("polish"));
   translateDate(cin, cout);
}