#include <iostream>
#include <boost/thread/thread.hpp>
#include <string>

// prosta klasa kolejki; zamiast niej normalnie wystpowaaby std::queue
template<typename T>
class Queue {
public:
   Queue( ) {}
  ~Queue( ) {}

   void enqueue(const T& x) {
      // blokowanie muteksu kolejki
      boost::mutex::scoped_lock lock(mutex_);
      list_.push_back(x);
      // muteks scoped_lock jest automatycznie usuwany po wyjciu z zasigu
      // (co oznacza, e zaoona blokada obowizuje tylko w biecym zasigu)
   } 

   T dequeue( ) {
      boost::mutex::scoped_lock lock(mutex_);

      if (list_.empty( ))
         throw "pusto!";      // opuszczenie biecego zasigu, a wic
      T tmp = list_.front( ); // zwolnienie blokady
      list_.pop_front( );
      return(tmp);
   } // zasig si koczy: zdjcie blokady mutex_

private:
   std::list<T> list_;
   boost::mutex mutex_;
};

Queue<std::string> queueOfStrings;

void sendSomething( ) {
   std::string s;
   for (int i = 0; i < 10; ++i) {
      queueOfStrings.enqueue("Test");
   }
}

void recvSomething( ) {
   std::string s;

   for (int i = 0; i < 10; ++i) {
      try {s = queueOfStrings.dequeue( );}
      catch(...) {}
   }
}

int main( ) {
   boost::thread thr1(sendSomething);
   boost::thread thr2(recvSomething);

   thr1.join( );
   thr2.join( );
}