#include <iostream>
#include <string>

using namespace std;

// ManipInfra to niewielka klasa wspomagajca implementacj
// wasnych manipulatorw strumieni przyjmujcych argumenty. 
// Wywoanie konstruktora klasy z argumentem w postaci wskanika
// funkcji naley osadzi w funkcji manipulatora. Wskanik powinien
// wskazywa funkcj realizujc waciwe zadanie manipulatora.
template<typename T, typename C>
class ManipInfra {

public:
   ManipInfra (basic_ostream<C>& (*pFun)
               (basic_ostream<C>&, T), T val)
     : manipFun_(pFun), val_(val) {}
   void operator( )(basic_ostream<C>& os) const
      {manipFun_(os, val_);}  // wywoanie wskanika funkcji z obiektem 
private:                      // strumienia i argumentem
   T val_;
   basic_ostream<C>& (*manipFun_)
      (basic_ostream<C>&, T);
};

template<typename T, typename C>
basic_ostream<C>& operator<<(basic_ostream<C>& os,
                             const ManipInfra<T, C>& manip) {
   manip(os);
   return(os);
}

// funkcja pomocnicza wywoywana z klasy ManipInfra
ostream& setTheWidth(ostream& os, int n) {
   os.width(n);
   return(os);
}

// funkcja manipulatora (wykorzystywana w wyraeniach zapisu do strumienia)
ManipInfra<int, char> setWidth(int n) {
   return(ManipInfra<int, char>(setTheWidth, n));
}

// inna funkcja pomocnicza, przyjmujca argument typu char
ostream& setTheFillChar(ostream& os, char c) {
   os.fill(c);
   return(os);
}

ManipInfra<char, char> setFill(char c) {
   return(ManipInfra<char, char>(setTheFillChar, c));
}

int main( ) {

  cout << setFill('-')
       << setWidth(10) << right << "Prus\n";
}