#include <iostream>

using namespace std;

class Balance {
   // operatory musz mie dostp do prywatnych skadowych klasy
   friend const Balance operator+(const Balance& lhs, const Balance& rhs);
   friend const Balance operator+(double lhs, const Balance& rhs);
   friend const Balance operator+(const Balance& lhs, double rhs);

public:
   Balance( ) : val_(0.0) {}
   Balance(double val) : val_(val) {}
  ~Balance( ) {}

   // operatory jednoargumentowe
   Balance& operator+=(const Balance& other) {
      val_ += other.val_;
      return(*this);
   }
   Balance& operator+=(double other) {
      val_ += other;
      return(*this);
   }
   
   double getVal( ) const {return(val_);}

private:
   double val_;
};

// operatory dwuargumentowe
const Balance operator+(const Balance& lhs, const Balance& rhs) {
   Balance tmp(lhs.val_ + rhs.val_);
   return(tmp);
}

const Balance operator+(double lhs, const Balance& rhs) {
   Balance tmp(lhs + rhs.val_);
   return(tmp);
}

const Balance operator+(const Balance& lhs, double rhs) {
   Balance tmp(lhs.val_ + rhs);
   return(tmp);
}

int main( ) {

   Balance checking(500.00), savings(23.91);

   checking += 50;
   Balance total = checking + savings;

   cout << "Saldo rachunku czekowego: " << checking.getVal( ) << '\n';
   cout << "Saldo czne:             "    << total.getVal( ) << '\n';
}