#include <iostream>
#include <set>
#include <map>
#include <string>

using namespace std;

typedef set<string> SetStr;
typedef map<string, SetStr*> MapStrSetStr;

// atrapa klasy bazodanowej
class DBConn {
public:
   void beginTxn( ) {}
   void endTxn( ) {}
   void execSql(string& sql) {}
};

class SimpleTxnLog {

public:
   SimpleTxnLog( ) {}
  ~SimpleTxnLog( ) {purge( );}

   // dodanie do listy zapytania SQL
   void addTxn(const string& id,
               const string& sql) {
      SetStr* pSet = log_[id];      // utworzenie wpisu dla danego id,
      if (pSet == NULL) {           // jeli nie ma jeszcze swojego wpisu
         pSet = new SetStr( );
         log_[id] = pSet;
      }
      pSet->insert(sql);
   }

   // przekazanie zapyta SQL do bazy danych,
   // w oddzielnych transakcjach
   void apply( ) {
      for (MapStrSetStr::iterator p = log_.begin( );
           p != log_.end( ); ++p) {
         conn_->beginTxn( );

         // iterator kontenera map odnosi si do obiektw typu
         // pair<Key,Val>; wskanik kontenera set jest w nim dostpny
         // jako p->second
         for (SetStr::iterator pSql = p->second->begin( );
              pSql != p->second->end( ); ++pSql) {
            string s = *pSql;
            conn_->execSql(s);
            cout << "Wykonywanie zapytania SQL: " << s << endl;
         }

         conn_->endTxn( );
         delete p->second;
      }
      log_.clear( );
   }

   void purge( ) {
      for (MapStrSetStr::iterator p = log_.begin( );
           p != log_.end( ); ++p)
        delete p->second;

      log_.clear( );
   }
  // ...

private:
   MapStrSetStr log_;
   DBConn* conn_;
};
