#include <iostream>
#include <boost/lexical_cast.hpp>

using namespace std;
using boost::lexical_cast;
using boost::bad_lexical_cast;

template<typename T>
bool isValid(const string& num) {
  bool res = true;
  try {
    T tmp = lexical_cast<T>(num);
  }
  catch (bad_lexical_cast &e) {
    res = false;
  }
  return(res);
}

void test(const string& s) {
  if (isValid<int>(s))
    cout << s << " jest poprawn wartoci typu integer." << endl;
  else
    cout << s << " NIE JEST poprawn wartoci typu integer." << endl;
  if (isValid<double>(s))
    cout << s << " jest poprawn wartoci typu double." << endl;
  else
    cout << s << " NIE JEST poprawn wartoci typu double." << endl;
  if (isValid<float>(s))
    cout << s << " jest poprawn wartoci typu float." << endl;
  else
    cout << s << " NIE JEST poprawn wartoci typu float." << endl;
}

int main( ) {
  test("12345");
  test("1.23456");
  test("-1.23456");
  test(" - 1.23456");
  test("+1.23456");
  test(" 1.23456 ");
  test("asdf");
}
