# rozszerzenia nazw plikw do usunicia w ramach zadania clean
CLEANEXTS = obj lib

# nazwa zadania docelowego i katalogu instalacyjnego
OUTPUTFILE = libjohnpaul.lib
INSTALLDIR = ../binaries

# wzorzec reguy kompilacji pliku obiektowego z pliku .cpp
%.obj: %.cpp
	"$(MSVCDIR)/bin/cl" -c -nologo -EHsc -GR -Zc:forScope -Zc:wchar_t \
		$(CXXFLAGS) $(CPPFLAGS) -Fo"$@" $<

# zadanie domylne
.PHONY: all
all: $(OUTPUTFILE)

# kompilacja bibioteki libjohnpaul.a z plikw john.o, paul.o i johnpaul.o
$(OUTPUTFILE): john.obj paul.obj johnpaul.obj
	"$(MSVCDIR)/bin/link" -lib -nologo -out:"$@" $^

.PHONY: install
install:
	mkdir -p $(INSTALLDIR)
	cp -p $(OUTPUTFILE) $(INSTALLDIR)

.PHONY: clean
clean:
	for file in $(CLEANEXTS); do rm -f *.$$file; done

# oznaczenie zalenoci plikw .ccp od plikw .hpp
john.obj: john.hpp
paul.obj: paul.hpp
johnpaul. obj: john.hpp paul.hpp johnpaul.hpp