#include <iostream>
#include <string>
#include <functional>
#include <boost/thread/thread.hpp>

// synonim typu uatwiajcy zapis deklaracji
typedef void (*WorkerFunPtr)(const std::string&);

template<typename FunT,   // typ wywoywanej funkcji
         typename ParamT> // typ jej parametru
struct Adapter {
   Adapter(FunT f, ParamT& p) : // skonstruowanie adaptera i ustawienie skadowych
      f_(f), p_(&p) {}          // funkcji i jej argumentu
	
   void operator( )( ) { // wywoanie funkcji z jej argumentem
      f_(*p_);         
   }
private:
   FunT    f_;
   ParamT* p_;  // przechowywanie adresw, celem uniknicia zbdnego kopiowania
};

void worker(const std::string& s) {
   std::cout << s << '\n';
}

int main( ) {

   std::string s1 = "Pierwszy wtek!";
   std::string s2 = "Drugi wtek!";

   boost::thread thr1(Adapter<WorkerFunPtr, std::string>(worker, s1));
   boost::thread thr2(Adapter<WorkerFunPtr, std::string>(worker, s2));

   thr1.join( );
   thr2.join( );
}