#include <iostream>
#include <string>

using namespace std;

class Employer {
   friend ostream& operator<<              // koniecznie funkcja zaprzyjaniona,
     (ostream& out, const Employer& empr); // aby miaa dostp do
public:                                    // skadowych niepublicznych
   Employer( ) {}
  ~Employer( ) {}

   void setName(const string& name) {name_ = name;}
private:
   string name_;
};

class Employee {
   friend ostream& operator<<
     (ostream& out, const Employee& obj); 
public:
   Employee( ) : empr_(NULL) {}
  ~Employee( ) {if (empr_) delete empr_;}

   void setFirstName(const string& name) {firstName_ = name;}
   void setLastName(const string& name) {lastName_ = name;}
   void setEmployer(Employer& empr) {empr_ = &empr;}
   const Employer* getEmployer( ) const {return(empr_);}

private:
   string firstName_;
   string lastName_;
   Employer* empr_;
};

// pozwala na zapisanie obiektu Employer do strumienia...
ostream& operator<<(ostream& out, const Employer& empr) {

   out << empr.name_ << endl;

   return(out);
}

// pozwala na zapisanie obiektu Employee do strumienia...
ostream& operator<<(ostream& out, const Employee& emp) {

   out << emp.firstName_ << endl;
   out << emp.lastName_ << endl;
   if (emp.empr_)
     out << *emp.empr_ << endl;

   return(out);
}

int main( ) {

   Employee emp;
   string first = "Jean-Luck";
   string last = "Pickard";
   Employer empr;
   string name = "Enterprise";
   empr.setName(name);

   emp.setFirstName(first);
   emp.setLastName(last);
   emp.setEmployer(empr);

   cout << emp;  // wypisanie do strumienia
}