#include <iostream>
#include <string>

const static int DEFAULT_BUF_SIZE = 3;
const static int MAX_SIZE         = 4096;

class Message {

public:
   Message(int bufSize = DEFAULT_BUF_SIZE) :
      bufSize_(bufSize),
      initBufSize_(bufSize),
      msgSize_(0),
      key_("") {
      buf_ = new char[bufSize]; // uwaga: w ciele konstruktora
   }

  ~Message( ) {
      delete[] buf_;
   }

   // odporny na wyjtki konstruktor kopiujcy
   Message(const Message& orig) : 
      bufSize_(orig.bufSize_),
      initBufSize_(orig.initBufSize_),
      msgSize_(orig.msgSize_),
      key_(orig.key_) { // tu moe doj do zrzucenia wyjtku...

      buf_ = new char[orig.bufSize_];  // ...tu te
      copy(orig.buf_, orig.buf_+msgSize_, buf_); // tu ju nie
   }

   // odporne na wyjtki przypisanie, z odwoaniem do konstruktora kopiujcego
   Message& operator=(const Message& rhs) {

      Message tmp(rhs);   // konstrukcja (kopiujca) obiektu tymczasowego
      swapInternals(tmp); // podmiana skadowych
      return(*this);      // po opuszczeniu zasigu dojdzie do usunicia tmp
                          // wraz z oryginalnymi danymi
   }

   const char* data( ) {
      return(buf_);
   }

private:
   void swapInternals(Message& msg) {
      // key_ nie jest typem wbudowanym i moe zrzuca wyjtki,
      // wic zostanie podmieniony jako pierwszy.
      swap(key_, msg.key_);

      // jeli nie pojawi si wyjtek, mona podmieni wartoci proste
      swap(bufSize_,     msg.bufSize_);
      swap(initBufSize_, msg.initBufSize_);
      swap(msgSize_,     msg.msgSize_);
      swap(buf_,         msg.buf_);
   }
   int bufSize_;
   int initBufSize_;
   int msgSize_;
   char* buf_;
   string key_;
};