#include <iostream>
#include <istream>
#include <string>
#include <list>
#include <vector>
#include <algorithm>
#include <iterator>
#include "utils.h" // dla funkcji printContainer(): por. receptur 7.10

using namespace std;

int main( ) {

   cout << "Wprowad zestaw cigw: ";
   istream_iterator<string> start(cin);
   istream_iterator<string> end; // utworzenie "markera"
   vector<string> v(start, end);

   // standardowy algorytm sort porzdkuje elementy zakresu; operuje
   // na iteratorach swobodnego dostpu, wic mona nim sortowa wektory.
   sort(v.begin( ), v.end( ));
   printContainer(v);

   random_shuffle(v.begin( ), v.end( )); // See 7.2

   string* arr = new string[v.size( )];

   // kopiowanie elementw do tablicy
   copy(v.begin( ), v.end( ), &arr[0]);

   // sortowanie dziaa dla dowolnych zakresw, o ile argumenty
   // przejawiaj zachowanie waciwe dla iteratorw swobodnego dostpu.
   sort(&arr[0], &arr[v.size( )]);
   printRange(&arr[0], &arr[v.size( )]);

   // tworzenie listy identycznych elementw
   list<string> lst(v.begin( ), v.end( ));

   lst.sort( ); // samodzielna wersja sortowania nie zadziaa z list;
                // trzeba uy metody list::sort; zauwamy, e tym
                // samym nie da si uporzdkowa fragmentu listy

   printContainer(lst);
}
