/**************************************************************************************************
*
* \file G19_Strategy.cpp
* \brief Wytyczna 19.: Stosuj wzorzec Strategia do określania sposobu wykonywania operacji
*
* Copyright (C) 2022 Klaus Iglberger - wszystkie prawa zastrzeżone
*
* Ten plik należy do materiałów uzupełniających do książki "Projektowanie oprogramowania w języku C++"
* wydanej przez wydawnictwo Helion.
*
**************************************************************************************************/


//---- <Shape.h> ----------------------------------------------------------------------------------

class Shape
{
 public:
   virtual ~Shape() = default;

   virtual void draw( /* Jakieś argumenty  */ ) const = 0;
};


//---- <DrawStrategy.h> ---------------------------------------------------------------------------

template< typename T >
class DrawStrategy
{
 public:
   virtual ~DrawStrategy() = default;
   virtual void draw( T const& ) const = 0;
};


//---- <Circle.h> ---------------------------------------------------------------------------------

//#include <Shape.h>
//#include <DrawStrategy.h>
#include <memory>
#include <utility>

class Circle : public Shape
{
 public:
   using DrawCircleStrategy = DrawStrategy<Circle>;

   explicit Circle( double radius, std::unique_ptr<DrawCircleStrategy> drawer )
      : radius_( radius )
      , drawer_( std::move(drawer) )
   {
      /* Sprawdzenie, czy podany promień jest poprawny i czy 
         dana instancja std::unique_ptr jest różna od nullptr */
   }

   void draw( /* Jakieś argumenty  */ ) const override
   {
      drawer_->draw( *this /*, Jakieś argumenty  */ );
   }

   double radius() const { return radius_; }

 private:
   double radius_;
   std::unique_ptr<DrawCircleStrategy> drawer_;
};


//---- <Square.h> ---------------------------------------------------------------------------------

//#include <Shape.h>
//#include <DrawStrategy.h>
#include <memory>
#include <utility>

class Square : public Shape
{
 public:
   using DrawSquareStrategy = DrawStrategy<Square>;

   explicit Square( double side, std::unique_ptr<DrawSquareStrategy> drawer )
      : side_( side )
      , drawer_( std::move(drawer) )
   {
      /* Sprawdzenie, czy podana długość krawędzi jest poprawna i czy 
         dana instancja std::unique_ptr jest różna od nullptr */
   }

   void draw( /* Jakieś argumenty  */ ) const override
   {
      drawer_->draw( *this /*, Jakieś argumenty  */ );
   }

   double side() const { return side_; }

 private:
   double side_;
   std::unique_ptr<DrawSquareStrategy> drawer_;
};


//---- <DrawAllShapes.h> --------------------------------------------------------------------------

#include <memory>
#include <vector>
class Shape;

void drawAllShapes( std::vector<std::unique_ptr<Shape>> const& shapes );


//---- <DrawAllShapes.cpp> ------------------------------------------------------------------------

//#include <DrawAllShapes.h>
//#include <Shape.h>

void drawAllShapes( std::vector<std::unique_ptr<Shape>> const& shapes )
{
   for( auto const& shape : shapes )
   {
      shape->draw( /* Jakieś argumenty  */ );
   }
}


//---- <OpenGLCircleStrategy.h> ----------------

//#include <Circle.h>
//#include <DrawStrategy.h>
//#include /* Nagłówki biblioteki graficznej OpenGL */

class OpenGLCircleStrategy : public DrawStrategy<Circle>
{
 public:
   explicit OpenGLCircleStrategy( /* Argumenty związane z rysowaniem */ )
   {}

   void draw( Circle const& circle /*, ...*/ ) const override
   {
      // ... Implementacja logiki rysowania okręgu przy użyciu OpenGL
   }

 private:
   /* Dane składowe związane z rysowaniem, takie jak kolory, tekstury ... */
};


//---- <OpenGLSquareStrategy.h> ----------------

//#include <Square.h>
//#include <DrawStrategy.h>
//#include /* Nagłówki biblioteki graficznej OpenGL */

class OpenGLSquareStrategy : public DrawStrategy<Square>
{
 public:
   explicit OpenGLSquareStrategy( /* Argumenty związane z rysowaniem */ )
   {}

   void draw( Square const& square /*, ...*/ ) const override
   {
      // ... Implementacja logiki rysowania okręgu przy użyciu OpenGL
   }

 private:
   /* Dane składowe związane z rysowaniem, takie jak kolory, tekstury ... */
};


//---- <Main.cpp> ---------------------------------------------------------------------------------

//#include <Circle.h>
//#include <DrawAllShapes.h>
//#include <Square.h>
//#include <OpenGLCircleStrategy.h>
//#include <OpenGLSquareStrategy.h>
#include <memory>
#include <vector>
#include <cstdlib>

int main()
{
   using Shapes = std::vector<std::unique_ptr<Shape>>;

   Shapes shapes{};

   // Tworzymy kilka figur, a każda z nich będzie wyposażona
   // w odpowiednią strategię rysowania z wykorzystaniem OpenGL
   shapes.emplace_back(
      std::make_unique<Circle>(
         2.3, std::make_unique<OpenGLCircleStrategy>(/*...czerwony...*/) ) );
   shapes.emplace_back(
      std::make_unique<Square>(
         1.2, std::make_unique<OpenGLSquareStrategy>(/*...zielony...*/) ) );
   shapes.emplace_back(
      std::make_unique<Circle>(
         4.1, std::make_unique<OpenGLCircleStrategy>(/*...niebieski...*/) ) );

   drawAllShapes(shapes);

   return EXIT_SUCCESS;
}

