/**************************************************************************************************
*
* \file G19_Extensive_Hierarchy.cpp
* \brief Wytyczna 19.: Stosuj wzorzec Strategia do określania sposobu wykonywania operacji
*
* Copyright (C) 2022 Klaus Iglberger - wszystkie prawa zastrzeżone
*
* Ten plik należy do materiałów uzupełniających do książki "Projektowanie oprogramowania w języku C++"
* wydanej przez wydawnictwo Helion.
*
**************************************************************************************************/


//---- <Point.h> ----------------------------------------------------------------------------------

struct Point
{
   double x;
   double y;
};


//---- <Shape.h> ----------------------------------------------------------------------------------

class Shape
{
 public:
   virtual ~Shape() = default;

   virtual void draw( /* Jakieś argumenty */ ) const = 0;
};


//---- <Circle.h> ---------------------------------------------------------------------------------

//#include <Point.h>
//#include <Shape.h>

class Circle : public Shape
{
 public:
   explicit Circle( double radius )
      : radius_( radius )
   {
      /* Sprawdzenie, czy podany promień jest poprawny */
   }

   double radius() const { return radius_; }
   Point  center() const { return center_; }

   // ... Tu już nie ma implementacji funkcji składowej draw()

 private:
   double radius_;
   Point center_{};
};


//---- <OpenGLCircle.h> ---------------------------------------------------------------------------

//#include <Circle.h>

class OpenGLCircle : public Circle
{
 public:
   explicit OpenGLCircle( double radius )
      : Circle( radius )
   {}

   void draw( /* Jakieś argumenty */ ) const override;
};


//---- <OpenGLCircle.cpp> ----------------

//#include <OpenGLCircle.h>
//#include /* Nagłówki biblioteki graficznej OpenGL */

void OpenGLCircle::draw( /* Jakieś argumenty */ ) const
{
   // ... Implementing the logic for drawing a circle by means of OpenGL
}


//---- <Square.h> ---------------------------------------------------------------------------------

//#include <Point.h>
//#include <Shape.h>

class Square : public Shape
{
 public:
   explicit Square( double side )
      : side_( side )
   {
      /* Sprawdzenie, czy podana długość krawędzi jest poprawna */
   }

   double side  () const { return side_; }
   Point  center() const { return center_; }

   // ... Tu już nie ma implementacji funkcji składowej draw()

 private:
   double side_;
   Point center_{};
};


//---- <OpenGLSquare.h> ----------------

//#include <Square.h>

class OpenGLSquare : public Square
{
 public:
   explicit OpenGLSquare( double side )
      : Square( side )
   {}

   void draw( /* Jakieś argumenty */ ) const override;
};


//---- <OpenGLSquare.cpp> ----------------

//#include <OpenGLSquare.h>
//#include /* Nagłówki biblioteki graficznej OpenGL */

void OpenGLSquare::draw( /*some arguments*/ ) const
{
   // ... Implementing the logic for drawing a square by means of OpenGL
}


//---- <DrawAllShapes.h> --------------------------------------------------------------------------

#include <memory>
#include <vector>
class Shape;

void drawAllShapes( std::vector<std::unique_ptr<Shape>> const& shapes );


//---- <DrawAllShapes.cpp> ------------------------------------------------------------------------

//#include <DrawAllShapes.h>
//#include <Shape.h>

void drawAllShapes( std::vector<std::unique_ptr<Shape>> const& shapes )
{
   for( auto const& shape : shapes )
   {
      shape->draw( /* Jakieś argumenty */ );
   }
}


//---- <Main.cpp> ---------------------------------------------------------------------------------

//#include <OpenGLCircle.h>
//#include <OpenGLSquare.h>
//#include <DrawAllShapes.h>
#include <cstdlib>
#include <memory>
#include <vector>

int main()
{
   using Shapes = std::vector< std::unique_ptr<Shape> >;

   Shapes shapes{};

   // Tworzymy kilka figur
   shapes.emplace_back( std::make_unique<OpenGLCircle>( 2.3 ) );
   shapes.emplace_back( std::make_unique<OpenGLSquare>( 1.2 ) );
   shapes.emplace_back( std::make_unique<OpenGLCircle>( 4.1 ) );

   // Rysujemy wszystkie figury
   drawAllShapes( shapes );

   return EXIT_SUCCESS;
}

