/**************************************************************************************************
*
* \file G16_Cylic_Visitor.cpp
* \brief Wytyczna 16.: Stosuj wzorzec Obserwator do rozszerzania operacji
*
* Copyright (C) 2022 Klaus Iglberger - wszystkie prawa zastrzeżone
*
* Ten plik należy do materiałów uzupełniających do książki "Projektowanie oprogramowania w języku C++"
* wydanej przez wydawnictwo Helion.
*
**************************************************************************************************/


//---- <ShapeVisitor.h> ---------------------------------------------------------------------------

class Circle;
class Square;

class ShapeVisitor
{
 public:
   virtual ~ShapeVisitor() = default;

   virtual void visit( Circle const& /*, ...*/ ) const = 0;
   virtual void visit( Square const& /*, ...*/ ) const = 0;
   // Być może więcej funkcji visit(), po jednej dla każdej konkretnej figury
};


//---- <Shape.h> ----------------------------------------------------------------------------------

//#include <ShapeVisitor.h>

class Shape
{
 public:
   virtual ~Shape() = default;
   virtual void accept( ShapeVisitor const& v ) = 0;
};


//---- <Circle.h> ---------------------------------------------------------------------------------

//#include <Shape.h>

class Circle : public Shape
{
 public:
   explicit Circle( double radius )
      : radius_( radius )
   {
      /* Sprawdzenie, czy podany promień jest poprawna */
   }

   void accept( ShapeVisitor const& v ) override { v.visit(*this); }

   double radius() const { return radius_; }

 private:
   double radius_;
};


//---- <Square.h> ---------------------------------------------------------------------------------

//#include <Shape.h>

class Square : public Shape
{
 public:
   explicit Square( double side )
      : side_( side )
   {
      /* Sprawdzenie, czy podana długość krawędzi jest poprawna */
   }

   void accept( ShapeVisitor const& v ) override { v.visit(*this); }

   double side() const { return side_; }

 private:
   double side_;
};


//---- <Draw.h> -----------------------------------------------------------------------------------

//#include <Circle.h>
//#include <ShapeVisitor.h>
//#include <Square.h>

class Draw : public ShapeVisitor
{
 public:
   void visit( Circle const& c /*, ...*/ ) const override
   {
      // ... Implementacja logiki rysowania okręgu
   }

   void visit( Square const& s /*, ...*/ ) const override
   {
      // ... Implementacja logiki rysowania kwadratu
   }

   // Prawdopodobnie więcej funkcji visit(), po jednej dla każdej konkretnej figury
};


//---- <DrawAllShapes.h> --------------------------------------------------------------------------

#include <memory>
#include <vector>
class Shape;

void drawAllShapes( std::vector<std::unique_ptr<Shape>> const& shapes );


//---- <DrawAllShapes.cpp> ------------------------------------------------------------------------

//#include <DrawAllShapes.h>
//#include <Draw.h>
//#include <Shape.h>

void drawAllShapes( std::vector<std::unique_ptr<Shape>> const& shapes )
{
   for( auto const& shape : shapes )
   {
      shape->accept( Draw{} );
   }
}


//---- <Main.cpp> ---------------------------------------------------------------------------------

//#include <Circle.h>
//#include <Square.h>
//#include <DrawAllShapes.h>
#include <cstdlib>
#include <memory>
#include <vector>

int main()
{
   using Shapes = std::vector< std::unique_ptr<Shape> >;

   Shapes shapes{};

   // Tworzymy kilka figur
   shapes.emplace_back( std::make_unique<Circle>( 2.3 ) );
   shapes.emplace_back( std::make_unique<Square>( 1.2 ) );
   shapes.emplace_back( std::make_unique<Circle>( 4.1 ) );

   // Rysujemy wszystkie figury
   drawAllShapes( shapes );

   return EXIT_SUCCESS;
}

