/**************************************************************************************************
*
* \file G15_Procedural_Solution.cpp
* \brief Wytyczna 15.: Projektuj pod kątem dodawania typów i operacji
*
* Copyright (C) 2022 Klaus Iglberger - wszystkie prawa zastrzeżone
*
* Ten plik należy do materiałów uzupełniających do książki "Projektowanie oprogramowania w języku C++"
* wydanej przez wydawnictwo Helion.
*
**************************************************************************************************/


//---- <Point.h> ----------------------------------------------------------------------------------

struct Point
{
   double x;
   double y;
};


//---- <Shape.h> ----------------------------------------------------------------------------------

enum ShapeType
{
   circle,
   square
};

class Shape
{
 protected:
   explicit Shape( ShapeType type )
      : type_( type )
   {}

 public:
   virtual ~Shape() = default;

   ShapeType getType() const { return type_; }

 private:
   ShapeType type_;
};


//---- <Circle.h> ---------------------------------------------------------------------------------

//#include <Point.h>
//#include <Shape.h>

class Circle : public Shape
{
 public:
   explicit Circle( double radius )
      : Shape( circle )
      , radius_( radius )
   {
      /* Sprawdzenie, czy podany promień jest poprawny */
   }

   double radius() const { return radius_; }
   Point  center() const { return center_; }

 private:
   double radius_;
   Point center_{};
};


//---- <DrawCircle.h> -----------------------------------------------------------------------------

class Circle;

void draw( Circle const& circle );


//---- <DrawCircle.cpp> ---------------------------------------------------------------------------

//#include <Circle.h>
//#include <DrawCircle.h>
//#include /* Jakaś biblioteka graficzna */

void draw( Circle const& circle )
{
   // ... Implementacja logiki rysowania okręgu
}


//---- <Square.h> ---------------------------------------------------------------------------------

//#include <Shape.h>
//#include <Point.h>

class Square : public Shape
{
 public:
   explicit Square( double side )
      : Shape( square )
      , side_( side )
   {
      /* Sprawdzenie, czy podana długość krawędzi jest poprawna */
   }

   double side  () const { return side_; }
   Point  center() const { return center_; }

 private:
   double side_;
   Point center_{};
};


//---- <DrawSquare.h> -----------------------------------------------------------------------------

class Square;

void draw( Square const& square );


//---- <DrawSquare.cpp> ---------------------------------------------------------------------------

//#include <DrawSquare.h>
//#include <Square.h>
//#include /* Jakaś biblioteka graficzna */

void draw( Square const& square )
{
   // ... Implementacja logiki rysowania kwadratu
}


//---- <DrawAllShapes.h> --------------------------------------------------------------------------

#include <memory>
#include <vector>
class Shape;

void drawAllShapes( std::vector<std::unique_ptr<Shape>> const& shapes );


//---- <DrawAllShapes.cpp> ------------------------------------------------------------------------

//#include <DrawAllShapes.h>
//#include <Circle.h>
//#include <Square.h>

void drawAllShapes( std::vector<std::unique_ptr<Shape>> const& shapes )
{
   for( auto const& shape : shapes )
   {
      switch( shape->getType() )
      {
         case circle:
            draw( static_cast<Circle const&>( *shape ) );
            break;
         case square:
            draw( static_cast<Square const&>( *shape ) );
            break;
      }
   }
}


//---- <Main.cpp> ---------------------------------------------------------------------------------

//#include <Circle.h>
//#include <Square.h>
//#include <DrawAllShapes.h>
#include <cstdlib>
#include <memory>
#include <vector>

int main()
{
   using Shapes = std::vector<std::unique_ptr<Shape>>;

   // Tworzymy kilka figur
   Shapes shapes{};
   shapes.emplace_back( std::make_unique<Circle>( 2.3 ) );
   shapes.emplace_back( std::make_unique<Square>( 1.2 ) );
   shapes.emplace_back( std::make_unique<Circle>( 4.1 ) );

   // Rysujemy wszystkie figury
   drawAllShapes( shapes );

   return EXIT_SUCCESS;
}

