/**************************************************************************************************
*
* \file G38_Singleton.cpp
* \brief Wytyczna 38.: Projektuj singletony pod kątem zmian i możliwości testowania
*
* Copyright (C) 2022 Klaus Iglberger - wszystkie prawa zastrzeżone
*
* Ten plik należy do materiałów uzupełniających do książki "Projektowanie oprogramowania w języku C++"
* wydanej przez wydawnictwo Helion.
*
**************************************************************************************************/


//---- <PersistenceInterface.h> -------------------------------------------------------------------

class PersistenceInterface
{
 public:
   virtual ~PersistenceInterface() = default;

   bool read( /* Jakieś argumenty */ ) const
   {
      return do_read( /*...*/ );
   }
   bool write( /* Jakieś argumenty */ )
   {
      return do_write( /*...*/ );
   }

   // ... Więcej funkcjonalności charakterystycznych dla bazy danych

 private:
   virtual bool do_read( /* Jakieś argumenty */ ) const = 0;
   virtual bool do_write( /* Jakieś argumenty */ ) = 0;
};

PersistenceInterface* get_persistence_interface();
void set_persistence_interface( PersistenceInterface* persistence );

// Deklaracja jednej zmiennej 'instance' 
extern PersistenceInterface* instance;


//---- <Database.h> -------------------------------------------------------------------------------

class Database : public PersistenceInterface
{
 public:
   Database() = default;

   // ... Prawdopodobnie funkcje zapewniające dostęp do danych składowych

   // Unieruchamiamy klasę przez usunięcie operacji kopiowania i przenoszenia
   Database( Database const& ) = delete;
   Database& operator=( Database const& ) = delete;
   Database( Database&& ) = delete;
   Database& operator=( Database&& ) = delete;

 private:
   bool do_read( /* Jakieś argumenty */ ) const override
   {
      /* Odczyt z bazy danych */
      return true;
   }

   bool do_write( /* Jakieś argumenty */ ) override
   {
      /* Zapis do bazy danych */
      return true;
   }

   // ... Więcej funkcjonalności charakterystycznych dla baz danych

   // ... Potencjalnie więcej danych składowych

};


//---- <PersistenceInterface.cpp> -----------------------------------------------------------------

//#include <Database.h>

// Definicja zmiennej 'instance'
PersistenceInterface* instance = nullptr;

PersistenceInterface* get_persistence_interface()
{
   // Obiekt lokalny, inicjowany przy użyciu
   // bezzwłocznie wywoływanego wyrażenia lambda (IILE)
   static bool init = [](){
      if( !instance ) {
         static Database db;
         instance = &db;
      }
      return true; // lub false, gdyż ta wartość nie ma znaczenia
   }(); // Zwróć uwagę na '()' za wyrażeniem lambda. Ta para nawiasów powoduje jego wywołanie

   return instance;
}

void set_persistence_interface( PersistenceInterface* persistence )
{
   instance = persistence;
}


//---- <Widget.h> ---------------------------------------------------------------------------------

//#include <PersistenceInterface.h>

class Widget
{
 public:
   Widget( PersistenceInterface* persistence )  // Wstrzyknięcie zależności
      : persistence_(persistence)
   {}

   void doSomething( /* Jakieś argumenty */ )
   {
      doSomething( get_persistence_interface() /*, Jakieś argumenty */ );
   }

   void doSomething( PersistenceInterface* persistence /*, Jakieś argumenty */ )
   {
      // ...
      persistence->read( /* Jakieś argumenty */ );
      // ...
   }

 private:
   PersistenceInterface* persistence_{};
};


//---- <CustomPersistence.h> ----------------------------------------------------------------------

//#include <PersistenceInterface.h>
#include <iostream>

class CustomPersistence : public PersistenceInterface
{
 public:
   CustomPersistence() = default;
   CustomPersistence( CustomPersistence const& db ) = default;

   bool do_read( /* Jakieś argumenty */ ) const override
   {
      /* Odczyt z niestandardowego systemu zapewniania trwałości */
      return true;
   }

   bool do_write( /* Jakieś argumenty */ ) override
   {
      /* Zapis do niestandardowego systemu zapewniania trwałości */
      return true;
   }

   // ... Więcej funkcjonalności charakterystycznych dla baz danych
 private:
   // ... Potencjalnie więcej szczegółów implementacyjnych i danych składowych
};


//---- <Main.cpp> ---------------------------------------------------------------------------------

//#include <PersistenceInterface.h>
#include <cstdlib>

int main()
{
   CustomPersistence persistence;
   set_persistence_interface( &persistence );

   Widget widget{ get_persistence_interface() };
   widget.doSomething();

   // ...

   return EXIT_SUCCESS;
}

