/**************************************************************************************************
*
* \file G28_Bridge.cpp
* \brief Wytyczna 28.: Tworzenie mostów w celu eliminacji fizycznych zależności
*
* Copyright (C) 2022 Klaus Iglberger - wszystkie prawa zastrzeżone
*
* Ten plik należy do materiałów uzupełniających do książki "Projektowanie oprogramowania w języku C++"
* wydanej przez wydawnictwo Helion.
*
**************************************************************************************************/


//---- <Engine.h> ---------------------------------------------------------------------------------

class Engine
{
 public:
   virtual ~Engine() = default;
   virtual void start() = 0;
   virtual void stop() = 0;
   // ... Więcej funkcji związanych z silnikiem

 private:
   // ...
};


//---- <Car.h> ------------------------------------------------------------------------------------

//#include <Engine.h>
#include <memory>
#include <utility>

class Car
{
 protected:
   explicit Car( std::unique_ptr<Engine> engine )
      : pimpl_{ std::move(engine) }
   {}

 public:
   virtual ~Car() = default;
   virtual void drive() = 0;
   // ... Więcej funkcji związanych z samochodem

 protected:
   Engine*       getEngine()       { return pimpl_.get(); }
   Engine const* getEngine() const { return pimpl_.get(); }

 private:
   std::unique_ptr<Engine> pimpl_;  // Wskaźnik do implementacji (pimpl)

   // ... Więcej danych składowych dotyczących samochodu (koła, układ przeniesienia napędu...)
};


//---- <ElectricEngine.h> -------------------------------------------------------------------------

//#include <Engine.h>

class ElectricEngine : public Engine
{
 public:
   void start() override;
   void stop() override;

 private:
   // ...
};


//---- <ElectricEngine.cpp> -----------------------------------------------------------------------

//#include <ElectricEngine.h>
#include <iostream>

void ElectricEngine::start()
{
   std::cout << "Uruchamiamy 'ElectricEngine'...\n";
}

void ElectricEngine::stop()
{
   std::cout << "Zatrzymujemy 'ElectricEngine'...\n";
}


//---- <ElectricCar.h> ----------------------------------------------------------------------------

//#include <Car.h>

class ElectricCar : public Car
{
 public:
   ElectricCar();

   void drive();
   // ...

 private:
   // ...
};


//---- <ElectricCar.cpp> --------------------------------------------------------------------------

//#include <ElectricCar.h>
//#include <ElectricEngine.h>
#include <iostream>

ElectricCar::ElectricCar()
   : Car{ std::make_unique<ElectricEngine>( /* Argumenty silnika */ ) }
   // ... Inicjalizacja innych danych składowych
{}

void ElectricCar::drive()
{
   getEngine()->start();
   std::cout << "Jeździmy 'ElectricCar'...\n";
   getEngine()->stop();
}

// ... Inne funkcje składowe 'ElectricCar', głownie używające abstrakcji 'Engine',
//     choć potencjalnie także i takie, które bezpośrednio operują na 
//     instancji 'ElectricEngine'


//---- <Main.cpp> ---------------------------------------------------------------------------------

//#include <ElectricCar.h>
#include <cstdlib>

int main()
{
   ElectricCar ecar{};
   ecar.drive();

   return EXIT_SUCCESS;
}

