/**************************************************************************************************
*
* \file G30_Prototype.cpp
* \brief Wytyczna 30.: Stosuj wzorzec Prototyp by wyodrębnić operacje kopiowania
*
* Copyright (C) 2022 Klaus Iglberger - wszystkie prawa zastrzeżone
*
* Ten plik należy do materiałów uzupełniających do książki "Projektowanie oprogramowania w języku C++"
* wydanej przez wydawnictwo Helion.
*
**************************************************************************************************/


//---- <Animal.h> ---------------------------------------------------------------------------------

#include <memory>

class Animal
{
 public:
   virtual ~Animal() = default;
   virtual void makeSound() const = 0;
   virtual std::unique_ptr<Animal> clone() const = 0; // Wzorzec projektowy Prototyp
};


//---- <Sheep.h> ----------------------------------------------------------------------------------

//#include <Animal.h>
#include <string>

class Sheep : public Animal
{
 public:
   explicit Sheep( std::string name ) : name_{ std::move(name) } {}

   void makeSound() const override;
   std::unique_ptr<Animal> clone() const override;  // Wzorzec projektowy Prototyp

 private:
   std::string name_;
};


//---- <Sheep.cpp> --------------------------------------------------------------------------------

//#include <Sheep.h>
#include <iostream>

void Sheep::makeSound() const
{
   std::cout << "baa\n";
}

std::unique_ptr<Animal> Sheep::clone() const
{
   return std::make_unique<Sheep>(*this);  // Konstruktor kopiujący owcy
}


//---- <Main.cpp> ---------------------------------------------------------------------------------

//#include <Sheep.h>
#include <cstdlib>
#include <memory>

int main()
{
   std::unique_ptr<Animal> dolly = std::make_unique<Sheep>( "Dolly" );
   std::unique_ptr<Animal> dollyClone = dolly->clone();

   dolly->makeSound();       // Odtwarza odgłos wydawany przez pierwszą Dolly
   dollyClone->makeSound();  // Klon wydaje takie same odgłosy jak oryginalna Dolly

   return EXIT_SUCCESS;
}
