/**************************************************************************************************
*
* \file G23_Strategy.cpp
* \brief Wytyczna 23.: Preferuj implementację wzorca Strategia korzystającą z wartości
*
* Copyright (C) 2022 Klaus Iglberger - wszystkie prawa zastrzeżone
*
* Ten plik należy do materiałów uzupełniających do książki "Projektowanie oprogramowania w języku C++"
* wydanej przez wydawnictwo Helion.
*
**************************************************************************************************/


//---- <Shape.h> ----------------------------------------------------------------------------------

class Shape
{
 public:
   virtual ~Shape() = default;
   virtual void draw( /* Jakieś argumenty */ ) const = 0;
};


//---- <Circle.h> ---------------------------------------------------------------------------------

//#include <Shape.h>
#include <functional>
#include <utility>

class Circle : public Shape
{
 public:
   using DrawStrategy = std::function<void(Circle const& /*, ...*/)>;

   explicit Circle( double radius, DrawStrategy drawer )
      : radius_( radius )
      , drawer_( std::move(drawer) )
   {
      /* Sprawdzenie, czy podany promień jest poprawny i czy 
         dana instancja std::function nie jest pusta */
   }

   void draw( /* Jakieś argumenty */ ) const override
   {
      drawer_( *this /*, Jakieś argumenty */ );
   }

   double radius() const { return radius_; }

 private:
   double radius_;
   DrawStrategy drawer_;
};


//---- <Square.h> ---------------------------------------------------------------------------------

//#include <Shape.h>
#include <functional>
#include <utility>

class Square : public Shape
{
 public:
   using DrawStrategy = std::function<void(Square const& /*, ...*/)>;

   explicit Square( double side, DrawStrategy drawer )
      : side_( side )
      , drawer_( std::move(drawer) )
   {
      /* Sprawdzenie, czy podana długość krawędzi jest poprawna i czy 
       dana instancja std::function nie jest pusta */
   }

   void draw( /* Jakieś argumenty */ ) const override
   {
      drawer_( *this /*, Jakieś argumenty */ );
   }

   double side() const { return side_; }

 private:
   double side_;
   DrawStrategy drawer_;
};


//---- <OpenGLCircleStrategy.h> -------------------------------------------------------------------

//#include <Circle.h>
//#include /* Nagłówki biblioteki graficznej OpenGL */

class OpenGLCircleStrategy
{
 public:
   explicit OpenGLCircleStrategy( /* Argumenty związane z rysowaniem */ )
   {}

   void operator()( Circle const& circle /*, ...*/ ) const
   {
      // ... Implementacja logiki rysowania koła przy użyciu OpenGL
   }

 private:
   /* Dane składowe związane z rysowaniem, np. kolory, tekstury ... */
};


//---- <OpenGLSquareStrategy.h> -------------------------------------------------------------------

//#include <Square.h>
//#include /* Nagłówki biblioteki graficznej OpenGL */

class OpenGLSquareStrategy
{
 public:
   explicit OpenGLSquareStrategy( /* Argumenty związane z rysowaniem */ )
   {}

   void operator()( Square const& square /*, ...*/ ) const
   {
      // ... Implementacja logiki rysowania kwadratu przy użyciu OpenGL
   }

 private:
   /* Dane składowe związane z rysowaniem, np. kolory, tekstury ... */
};


//---- <Main.cpp> ---------------------------------------------------------------------------------

//#include <Circle.h>
//#include <Square.h>
//#include <OpenGLCircleStrategy.h>
//#include <OpenGLSquareStrategy.h>
#include <memory>
#include <vector>

int main()
{
   using Shapes = std::vector<std::unique_ptr<Shape>>;

   Shapes shapes{};

   // Tworzymy kilka figur i do każdej z nich przekazujemy
   // odpowiednią strategię rysowania OpenGL
   shapes.emplace_back(
      std::make_unique<Circle>( 2.3, OpenGLCircleStrategy(/*...czerwona...*/) ) );
   shapes.emplace_back(
      std::make_unique<Square>( 1.2, OpenGLSquareStrategy(/*...zielona...*/) ) );
   shapes.emplace_back(
      std::make_unique<Circle>( 4.1, OpenGLCircleStrategy(/*...niebieska...*/) ) );

   // Wyświetlamy wszystkie figury
   for( auto const& shape : shapes )
   {
      shape->draw();
   }

   return EXIT_SUCCESS;
}

