/**************************************************************************************************
*
* \file G23_Function.cpp
* \brief Wytyczna 23.: Preferuj implementację wzorca Strategia korzystającą z wartości
*
* Copyright (C) 2022 Klaus Iglberger - wszystkie prawa zastrzeżone
*
* Ten plik należy do materiałów uzupełniających do książki "Projektowanie oprogramowania w języku C++"
* wydanej przez wydawnictwo Helion.
*
**************************************************************************************************/


#include <cstdlib>
#include <functional>
#include <iostream>

void foo( int i )
{
   std::cout << "foo: " << i << '\n';
}

int main()
{
   // Tworzymy domyślną instancję std::function. Jej wywołanie skutkuje
   // zgłoszeniem wyjątku std::bad_function_call
   std::function<void(int)> f{};

   f = []( int i ){  // Przypisujemy 'f' obiekt wywoływalny  
      std::cout << "lambda: " << i << '\n';
   };

   f(1);  // Wywołujemy 'f', przekazując do niego liczbę całkowitą 1

   auto g = f;  // Kopiujemy 'f' do 'g'

   f = foo;  // Przypisujemy 'f' inny obiekt wywoływalny 

   f(2);  // Wywołujemy 'f', przekazując liczbę całkowitą 2
   g(3);  // Wywołujemy 'g', przekazując liczbę całkowitą 3

   return EXIT_SUCCESS;
}

