/**************************************************************************************************
*
* \file G22_Example_2.cpp
* \brief Wytyczna 22.: Preferuj semantykę wartości od semantyki referencji
*
* Copyright (C) 2022 Klaus Iglberger - wszystkie prawa zastrzeżone
*
* Ten plik należy do materiałów uzupełniających do książki "Projektowanie oprogramowania w języku C++"
* wydanej przez wydawnictwo Helion.
*
**************************************************************************************************/


#include <cstdlib>
#include <iostream>
#include <span>
#include <vector>
#include <algorithm>

void print( std::span<int> s )
{
   std::cout << " (";
   for( int i : s ) {
      std::cout << ' ' << i;
   }
   std::cout << " )\n";
}

int main()
{
   std::vector<int> vec{ 1, -3, 27, 42, 4, -8, 22, 42, 37, 4, 18, 9 };

   auto const pos = std::max_element( begin(vec), end(vec) );

   vec.erase( std::remove( begin(vec), end(vec), *pos ), end(vec) );

   print( vec );

   return EXIT_SUCCESS;
}

