/**************************************************************************************************
*
* \file G28_Pimpl.cpp
* \brief Wytyczna 28.: Tworzenie mostów w celu eliminacji fizycznych zależności
*
* Copyright (C) 2022 Klaus Iglberger - wszystkie prawa zastrzeżone
*
* Ten plik należy do materiałów uzupełniających do książki "Projektowanie oprogramowania w języku C++"
* wydanej przez wydawnictwo Helion.
*
**************************************************************************************************/


//---- <Person.h> ---------------------------------------------------------------------------------

#include <memory>

class Person
{
 public:
   // ...
   Person();
   ~Person();

   Person( Person const& other );
   Person& operator=( Person const& other );

   Person( Person&& other );
   Person& operator=( Person&& other );

   int year_of_birth() const;
   // ... Wiele innych funkcji zapewniających dostęp do składowych obiektu

 private:
   struct Impl;
   std::unique_ptr<Impl> const pimpl_;
};


//---- <Person.cpp> -------------------------------------------------------------------------------

//#include <Person.h>
#include <string>

struct Person::Impl
{
   std::string forename;
   std::string surname;
   std::string address;
   std::string city;
   std::string country;
   std::string zip;
   int year_of_birth;
   // ... Potencjalnie wiele innych danych składowych
};


Person::Person()
   : pimpl_{ std::make_unique<Impl>() }
{}

Person::~Person() = default;

Person::Person( Person const& other )
   : pimpl_{ std::make_unique<Impl>(*other.pimpl_) }
{}

Person& Person::operator=( Person const& other )
{
   *pimpl_ = *other.pimpl_;
   return *this;
}

Person::Person( Person&& other )
   : pimpl_{ std::make_unique<Impl>(std::move(*other.pimpl_)) }
{}

Person& Person::operator=( Person&& other )
{
   *pimpl_ = std::move(*other.pimpl_);
   return *this;
}

int Person::year_of_birth() const
{
   return pimpl_->year_of_birth;
}

// ... Wiele innych funkcji składowych klasy Person


//---- <Main.cpp> ---------------------------------------------------------------------------------

//#include <Person.h>

int main()
{
   Person p1{};

   return EXIT_SUCCESS;
}

