/**************************************************************************************************
*
* \file G27_StrongType.cpp
* \brief Wytyczna 27.: Stosuj wzorzec CRTP do tworzenia statycznych klas domieszek
*
* Copyright (C) 2022 Klaus Iglberger - wszystkie prawa zastrzeżone
*
* Ten plik należy do materiałów uzupełniających do książki "Projektowanie oprogramowania w języku C++"
* wydanej przez wydawnictwo Helion.
*
**************************************************************************************************/


//---- <Addable.h> --------------------------------------------------------------------------------

template< typename Derived >
struct Addable
{
   friend Derived& operator+=( Derived& lhs, Derived const& rhs ) {
      lhs.get() += rhs.get();
      return lhs;
   }

   friend Derived operator+( Derived const& lhs, Derived const& rhs ) {
      return Derived{ lhs.get() + rhs.get() };
   }
};


//---- <Subtractable.h> ---------------------------------------------------------------------------

template< typename Derived >
struct Subtractable
{
   friend Derived& operator-=( Derived& lhs, Derived const& rhs ) {
      lhs.get() -= rhs.get();
      return lhs;
   }

   friend Derived operator-( Derived const& lhs, Derived const& rhs ) {
      return Derived{ lhs.get() - rhs.get() };
   }
};


//---- <IntegralArithmetic.h> ---------------------------------------------------------------------

//#include <Addable.h>
//#include <Subtractable.h>

template< typename Derived >
struct IntegralArithmetic
   : public Addable<Derived>
   , public Subtractable<Derived>
{};


//---- <Printable.h> ------------------------------------------------------------------------------

#include <iosfwd>

template< typename Derived >
struct Printable
{
   friend std::ostream& operator<<( std::ostream& os, Derived const& d )
   {
      os << d.get();
      return os;
   }
};


//---- <Swappable.h> ------------------------------------------------------------------------------

#include <utility>

template< typename Derived >
struct Swappable
{
   friend void swap( Derived& lhs, Derived& rhs )
   {
      using std::swap;  // Włączamy ADL
      swap( lhs.get(), rhs.get() );
   }
};


//---- <StrongType.h> -----------------------------------------------------------------------------

#include <utility>

template< typename T, typename Tag, template<typename> class... Skills >
struct StrongType
   : public Skills< StrongType<T,Tag,Skills...> >...
{
 public:
   using value_type = T;

   explicit constexpr StrongType( T const& value ) : value_( value ) {}

   constexpr T&       get()       noexcept { return value_; }
   constexpr T const& get() const noexcept { return value_; }

   void swap( StrongType& other ) {
      using std::swap;
      swap( value_, other.value_ );
   }

 private:
   T value_;
};

template< typename T, typename Tag, template<typename> class... Skills >
std::ostream& operator<<( std::ostream& os, StrongType<T,Tag,Skills...> const& nt )
{
   os << nt.get();
   return os;
}

template< typename T, typename Tag, template<typename> class... Skills >
void swap( StrongType<T,Tag,Skills...>& a, StrongType<T,Tag,Skills...>& b )
{
   a.swap( b );
}


//---- <Distances.h> ------------------------------------------------------------------------------

//#include <IntegralArithmetic.h>
//#include <Printable.h>
//#include <StrongType.h>
//#include <Swappable.h>

template< typename T >
using Meter = StrongType<T,struct MeterTag,IntegralArithmetic,Printable,Swappable>;

template< typename T >
using Kilometer = StrongType<T,struct KilometerTag,IntegralArithmetic,Printable,Swappable>;


//---- <Person.h> ---------------------------------------------------------------------------------

//#include <StrongType.h>
#include <string>

using Surname = StrongType<std::string,struct SurnameTag,Printable,Swappable>;


//---- <Main.cpp> ---------------------------------------------------------------------------------

//#include <Distances.h>
#include <cstdlib>
#include <iostream>

int main()
{
   auto const m1 = Meter<long>{ 100 };
   auto const m2 = Meter<long>{  50 };

   auto const m3 = m1 + m2;  // Kompiluje się i zwraca 150 metrów (Meter)

   std::cout << "\n m3  = " << m3 << "m\n\n";

   return EXIT_SUCCESS;
}
