/**************************************************************************************************
*
* \file G32_Type_Erasure.cpp
* \brief Wytyczna 32.: Rozważ zastąpienie hierarchii dziedziczenia wzorcem projektowym Ukrywanie typu
*
* Copyright (C) 2022 Klaus Iglberger - wszystkie prawa zastrzeżone
*
* Ten plik należy do materiałów uzupełniających do książki "Projektowanie oprogramowania w języku C++"
* wydanej przez wydawnictwo Helion.
*
**************************************************************************************************/


//---- <Circle.h> ---------------------------------------------------------------------------------

class Circle
{
 public:
   explicit Circle( double radius )
      : radius_( radius )
   {}

   double radius() const { return radius_; }
   /* Kilka innych, związanych z okręgami funkcji pobierających i pomocniczych */

 private:
   double radius_;
   /* Kilka innych danych składowych */
};


//---- <Square.h> ---------------------------------------------------------------------------------

class Square
{
 public:
   explicit Square( double side )
      : side_( side )
   {}

   double side() const { return side_; }
   /* Kilka innych, związanych z kwadratami funkcji pobierających i pomocniczych */

 private:
   double side_;
   /* Kilka innych danych składowych */
};


//---- <Shape.h> ----------------------------------------------------------------------------------

#include <memory>
#include <utility>

namespace detail {

class ShapeConcept  // Wzorzec projektowy Polimorfizm zewnętrzny
{
 public:
   virtual ~ShapeConcept() = default;
   virtual void draw() const = 0;
   virtual std::unique_ptr<ShapeConcept> clone() const = 0;  // Wzorzec projektowy Prototyp
};

template< typename ShapeT
        , typename DrawStrategy >
class OwningShapeModel : public ShapeConcept
{
 public:
   explicit OwningShapeModel( ShapeT shape, DrawStrategy drawer )
      : shape_{ std::move(shape) }
      , drawer_{ std::move(drawer) }
   {}

   void draw() const override { drawer_(shape_); }

   std::unique_ptr<ShapeConcept> clone() const override  // Wzorzec projektowy Prototyp
   {
      return std::make_unique<OwningShapeModel>( *this );
   }

 private:
   ShapeT shape_;
   DrawStrategy drawer_;
};

} // Koniec przestrzeni nazw detail


class Shape
{
 public:
   template< typename ShapeT
           , typename DrawStrategy >
   Shape( ShapeT shape, DrawStrategy drawer )
   {
      using Model = detail::OwningShapeModel<ShapeT,DrawStrategy>;
      pimpl_ = std::make_unique<Model>( std::move(shape)
                                      , std::move(drawer) );
   }

   Shape( Shape const& other )
      : pimpl_( other.pimpl_->clone() )
   {}

   Shape& operator=( Shape const& other )
   {
      // Idiom kopiuj i zamień
      Shape copy( other );
      pimpl_.swap( copy.pimpl_ );
      return *this;
   }

   ~Shape() = default;
   Shape( Shape&& ) = default;
   Shape& operator=( Shape&& ) = default;

 private:
   friend void draw( Shape const& shape )
   {
      shape.pimpl_->draw();
   }

   std::unique_ptr<detail::ShapeConcept> pimpl_;  // Wzorzec projektowy Most
};


//---- <Main.cpp> ---------------------------------------------------------------------------------

//#include <Circle.h>
//#include <Square.h>
//#include <Shape.h>
#include <cstdlib>

int main()
{
   // Tworzymy okrąg jako jednego reprezentanta konkretnych typów figur
   Circle circle{ 3.14 };

   // Tworzymy strategię rysowania w formie wyrażenia lambda
   auto drawer = []( Circle const& c ){ /*...*/ };

   // Łączymy figurę oraz strategię rysowania w abstrakcji Shape.
   // Ten konstruktor skonkretyzuje typ 'deatail::OwningShapeModel' dla 
   // podanego typu 'Circle' oraz podanego typu wyrażenia lambda
   Shape shape1( circle, drawer );

   // Rysujemy figurę
   draw( shape1 );

   // Tworzymy kopię figury przy użyciu konstruktora kopiującego
   Shape shape2( shape1 );

   // Narysowanie tej kopii da takie same wyniki
   draw( shape2 );

   return EXIT_SUCCESS;
}

