/**************************************************************************************************
*
* \file G29_Bridge_Performance.cpp
* \brief Wytyczna 29.: Bądź świadom zysków i strat wydajności we wzorcu projektowym Most
*
* Copyright (C) 2022 Klaus Iglberger - wszystkie prawa zastrzeżone
*
* Ten plik należy do materiałów uzupełniających do książki "Projektowanie oprogramowania w języku C++"
* wydanej przez wydawnictwo Helion.
*
* Skopiuj i wklej ten kod do witryny quick-bench.com. Zmierz czas jaki zajmie znalezienie
* najstarszej osoby w std::vector obiektów Person.
*
**************************************************************************************************/


#include <memory>
#include <numeric>
#include <random>
#include <string>
#include <vector>


//---- Benchmark configuration --------------------------------------------------------------------

constexpr size_t size( 10000 );  // Wielkość generowanego kontenera
constexpr size_t iterations( 10 );  // Liczba operacji w pomiarze wydajności 

#define BENCHMARK_PERSON1 1   // Brak mostu: wszystkie dane składowe w klasie
#define BENCHMARK_PERSON2 1   // Pełny most: wszystkie dane składowe ukryte za wskaźnikiem do implementacji (pimpl)
#define BENCHMARK_PERSON3 1   // Częściowy most: tylko rzadko używane dane składowe ukryte za wskaźnikiem do implementacji (pimpl)


//---- Random Number Setup ------------------------------------------------------------------------

std::random_device rd{};
const unsigned int seed( rd() );

std::mt19937 rng{};
std::uniform_int_distribution<int> dist( 1957, 2004 );

int get_random_year_of_birth()
{
   return dist( rd );
}


//---- Implementacje Person ---------------------------------------------------------------------

struct Person1
{
   std::string forename{ "Homer" };
   std::string surname{ "Simpson" };
   std::string address{ "712 Red Bark Lane" };
   std::string zip{ "89011" };
   std::string city{ "Henderson" };
   std::string state{ "Nevada" };
   int year_of_birth{ get_random_year_of_birth() };
};

struct Person2
{
   struct Pimpl {
      std::string forename{ "Homer" };
      std::string surname{ "Simpson" };
      std::string address{ "712 Red Bark Lane" };
      std::string zip{ "89011" };
      std::string city{ "Henderson" };
      std::string state{ "Nevada" };
      int year_of_birth{ get_random_year_of_birth() };
   };

   std::unique_ptr<Pimpl> pimpl{ new Pimpl{} };
};

struct Person3
{
   std::string forename{ "Homer" };
   std::string surname{ "Simpson" };
   int year_of_birth{ get_random_year_of_birth() };

   struct Pimpl {
      std::string address{ "712 Red Bark Lane" };
      std::string zip{ "89011" };
      std::string city{ "Henderson" };
      std::string state{ "Nevada" };
   };

   std::unique_ptr<Pimpl> pimpl{ new Pimpl{} };
};


//---- Pomiar dla Person1 ----------------------------------------------------------------------

static void determineOldestPerson1(benchmark::State& state)
{
   std::vector<Person1> persons( size );

   for( auto _ : state )
   {
      benchmark::DoNotOptimize(
         std::min_element( begin(persons), end(persons), []( auto const& p1, auto const& p2 ){
            return p1.year_of_birth < p2.year_of_birth;
         } )
      );
   }
}
#if BENCHMARK_PERSON1
BENCHMARK(determineOldestPerson1)->Iterations(iterations);
#endif


//---- Pomiar dla Person2 ----------------------------------------------------------------------

static void determineOldestPerson2(benchmark::State& state)
{
   std::vector<Person2> persons( size );

   for( auto _ : state )
   {
      benchmark::DoNotOptimize(
         std::min_element( begin(persons), end(persons), []( auto const& p1, auto const& p2 ){
            return p1.pimpl->year_of_birth < p2.pimpl->year_of_birth;
         } )
      );
   }
}
#if BENCHMARK_PERSON2
BENCHMARK(determineOldestPerson2)->Iterations(iterations);
#endif


//---- Pomiar dla Person3 ----------------------------------------------------------------------

static void determineOldestPerson3(benchmark::State& state)
{
   std::vector<Person3> persons( size );

   for( auto _ : state )
   {
      benchmark::DoNotOptimize(
         std::min_element( begin(persons), end(persons), []( auto const& p1, auto const& p2 ){
            return p1.year_of_birth < p2.year_of_birth;
         } )
      );
   }
}
#if BENCHMARK_PERSON3
BENCHMARK(determineOldestPerson3)->Iterations(iterations);
#endif

