/**************************************************************************************************
*
* \file G17_Variant.cpp
* \brief Wytyczna 17.: Rozważ użycie std::variant do implementacji wzorca Odwiedzający
*
* Copyright (C) 2022 Klaus Iglberger - wszystkie prawa zastrzeżone
*
* Ten plik należy do materiałów uzupełniających do książki "Projektowanie oprogramowania w języku C++"
* wydanej przez wydawnictwo Helion.
*
**************************************************************************************************/

#include <cstdlib>
#include <iostream>
#include <string>
#include <variant>


struct Print
{
   void operator()( int value ) const
      { std::cout << "int: " << value << '\n'; }
   void operator()( double value ) const
      { std::cout << "double: " << value << '\n'; }
   void operator()( std::string const& value ) const
      { std::cout << "string: " << value << '\n'; }
};


int main()
{
   // Tworzy domyślny wariant zainicjowany wartością całkowitą ('int') 0
   std::variant<int,double,std::string> v{};

   v = 42;        // Zapisuje w wariancie wartość całkowitą 42  
   v = 3.14;      // Zapisuje w wariancie wartość 3.14 typu 'double'     
   v = 2.71F;     // Zapisuje w wariancie wartość typu 'float', która jest promowana do typu 'double'   
   v = "Bjarne";  // Zapisuje w wariancie literał łańcuchowy 'Bjarne'    
   v = 43;        // Zapisuje w wariancie wartość całkowitą 43    

   int const i = std::get<int>(v);  // Bezpośrednie odwołanie do wartości    

   int* const pi = std::get_if<int>(&v);  // Bezpośrednie odwołanie do wartości    

   std::visit( Print{}, v );  // Zastosowanie odwiedzającego Print    

   return EXIT_SUCCESS;
}

