#include <algorithm>
#include <vector>
#include <string>
#include <iostream>
using namespace std;

template <typename T>
void DisplayContents (const T& Input)
{
   for(auto iElement = Input.cbegin() // auto i cbegin(): C++11.
      ; iElement != Input.cend() // cend() to nowość w C++11.
      ; ++ iElement )
      cout << *iElement << endl;
}
int main ()
{
    vector<string> vecNames;
    vecNames.push_back ("Cezary Pazura");
    vecNames.push_back ("Marek Kondrat");
    vecNames.push_back ("Marek Perepeczko");
    vecNames.push_back ("Anna Dereszowska");

    // Wstawienie duplikatu do obiektu vector.
    vecNames.push_back ("Marek Kondrat");

    cout << "Początkowa zawartość obiektu vector jest następująca:" << endl;
    DisplayContents(vecNames);

    cout << "Posortowany obiekt vector zawiera elementy w następującej kolejności:" << endl;
    sort (vecNames.begin (), vecNames.end ());
    DisplayContents(vecNames);

    cout << "Wyszukanie elementu \"Cezary Pazura\" za pomocą algorytmu 'binary_search':" << endl;
    bool bElementFound = binary_search (vecNames.begin (), vecNames.end (),
                                        "Cezary Pazura");

    if (bElementFound)
        cout << "Wynik: element \"Cezary Pazura\" został znaleziony w obiekcie vector!" << endl;
    else
        cout << "Element nie został znaleziony " << endl;

    // Usunięcie sąsiadujących ze sobą duplikatów.
    auto iNewEnd = unique (vecNames.begin (), vecNames.end ());
    vecNames.erase (iNewEnd, vecNames.end ());

    cout << "Zawartość obiektu vector po użyciu algorytmu 'unique' jest następująca:" << endl;
    DisplayContents(vecNames);

    return 0;
}
