#include<iostream>
#include<string>
#include<unordered_map>
using namespace std;

template <typename T1, typename T2>
void DisplayUnorderedMap(unordered_map<T1, T2>& Input)
{
   cout << "Liczba par, size() = " << Input.size() << endl;
   cout << "Maksymalna liczba kubełków = " << Input.max_bucket_count() << endl;
   cout << "Współczynnik wypełniania: " << Input.load_factor() << endl;
   cout << "Maksymalny współczynnik wypełniania = " << Input.max_load_factor() << endl;
   cout << "Zawartość nieposortowanego obiektu map: " << endl;

   for(auto iElement = Input.cbegin() // auto, cbegin: C++11.
      ; iElement != Input.cend()  // cend() to nowość w C++11.
      ; ++ iElement )
      cout<< iElement->first<< " -> "<< iElement->second<< endl;
}

int main()
{
   unordered_map<int, string> umapIntToString;
   umapIntToString.insert(make_pair(1, "Jeden"));
   umapIntToString.insert(make_pair(45, "Czterdzieści Pięć"));
   umapIntToString.insert(make_pair(1001, "Tysiąc Jeden"));
   umapIntToString.insert(make_pair(-2, "Minus Dwa"));
   umapIntToString.insert(make_pair(-1000, "Minus Tysiąc"));
   umapIntToString.insert(make_pair(100, "Sto"));
   umapIntToString.insert(make_pair(12, "Dwanaście"));
   umapIntToString.insert(make_pair(-100, "Minus Sto"));

   DisplayUnorderedMap<int, string>(umapIntToString);

   cout << "Wstawienie jeszcze jednego elementu" << endl;
   umapIntToString.insert(make_pair(300, "Trzysta"));
   DisplayUnorderedMap<int, string>(umapIntToString);

   cout << "Podaj szukany klucz: ";
   int Key = 0;
   cin >> Key;

   auto iElementFound = umapIntToString.find(Key);
   if (iElementFound != umapIntToString.end())
   {
      cout << "Znaleziono! Klucz " << iElementFound->first << " prowadzi do wartości";
      cout << iElementFound->second << endl;
   }
   else
      cout << "Klucz nie ma odpowiadającej mu wartości w obiekcie map!" << endl; 

   return 0;
}
