#include <set>
#include <iostream>
using namespace std;

template <typename T>
void DisplayContents(const T& Input)
{
    for (auto iElement = Input.cbegin() // auto i cbegin() dla C++11.
        ; iElement != Input.cend() // cend() to nowość w C++11.
        ; ++ iElement )
       cout << *iElement << ' '; 

    cout << endl;
}

typedef multiset <int> MSETINT;

int main ()
{
    MSETINT msetIntegers;

    // Wstawienie kilku losowo wybranych wartości.
    msetIntegers.insert (43);
    msetIntegers.insert (78);
    msetIntegers.insert (78);    // Duplikat.
    msetIntegers.insert (-1);
    msetIntegers.insert (124);

    cout << "Obiekt multiset zawiera " << msetIntegers.size () << " element(y/ów).";
    cout << " Są nimi: " << endl;

    // Wyświetlenie na ekranie zawartości obiektu multiset.
    DisplayContents(msetIntegers);

    cout << "Proszę podać liczbę do usunięcia z obiektu set" << endl;
    int nNumberToErase = 0;
    cin >> nNumberToErase;

    cout << "Usuwanie " << msetIntegers.count (nNumberToErase);
    cout << " egzemplarzy wartości " << nNumberToErase << endl;

    // Próba wyszukania elementu.
    msetIntegers.erase (nNumberToErase);

    cout << "Obiekt multiset zawiera " << msetIntegers.size () << " element(y/ów).";
    cout << " Są nimi: " << endl;
    DisplayContents(msetIntegers);

    return 0;
}
