#include <iostream>
#include <memory>  // To polecenie jest konieczne w celu użycia std::unique_ptr.
using namespace std;

class Date
{
private:
   int Day;
   int Month;
   int Year;

   string DateInString;

public:
   // Konstruktor inicjalizujący obiekt dla dnia, miesiąca i roku.
   Date (int InputDay, int InputMonth, int InputYear)
      : Day (InputDay), Month (InputMonth), Year (InputYear) {};

   void DisplayDate()
   {
      cout << Day << " / " << Month << " / " << Year << endl;
   }
};

int main()
{
   unique_ptr<int> pDynamicAllocInteger(new int);
   *pDynamicAllocInteger = 42;

   // Użycie sprytnego wskaźnika typu, takiego jak  int*.
   cout << "Liczba całkowita to: " << *pDynamicAllocInteger << endl;

   unique_ptr<Date> pHoliday (new Date(25, 11, 2011));
   cout << "Nowy egzemplarz daty zawiera: ";

   // Użycie pHoliday w taki sposób, jakby to był Date*.
   pHoliday->DisplayDate();

   // Podczas używania unique_ptr poniższe polecenia są zbędne:
   // delete pDynamicAllocInteger;
   // delete pHoliday;

   return 0;
}
