#include <iostream>
#include <string>
using namespace std;

class MyString
{
private:
   char* Buffer;

   // Domyślny konstruktor prywatny.
   MyString() {}

public:
   // Konstruktor.
   MyString(const char* InitialInput)
   {
      if(InitialInput != NULL)
      {
         Buffer = new char [strlen(InitialInput) + 1];
         strcpy(Buffer, InitialInput);
      }
      else
         Buffer = NULL;
   }

   // Konstruktor kopiujący: wstaw tutaj kod z listingu 9.9.
   MyString(const MyString& CopySource);

   // Kopiujący operator przypisania: wstaw tutaj kod z listingu 12.9.
   MyString& operator= (const MyString& CopySource);

   const char& operator[] (int Index) const
   {
      if (Index < GetLength())
         return Buffer[Index];
   }

   // Destruktor.
   ~MyString()
   {
      if (Buffer != NULL)
         delete [] Buffer;
   }

   int GetLength() const
   {
      return strlen(Buffer);
   } 

   operator const char*()
   {
      return Buffer;
   }
};

int main()
{
   cout << "Podaj zdanie: ";
   string strInput;
   getline(cin, strInput);

   MyString youSaid(strInput.c_str());

   cout << "Użycie operatora [] do wyświetlenia danych wejściowych: " << endl;
   for(int Index = 0; Index < youSaid.GetLength(); ++Index)
      cout << youSaid[Index] << " ";
   cout << endl;

   cout << "Podaj indeks z zakresu 0 - " << youSaid.GetLength() - 1 << ": ";
   int InIndex = 0;
   cin >> InIndex;
   cout << "Znak danych wejściowych w położeniu liczonym od zera: " << InIndex; 
   cout << " to: "<< youSaid[InIndex] << endl;

   return 0;
}
