#include <iostream>
using namespace std;

class Date
{
private:
   int Day;  // Zakres: 1 - 30 (przyjmujemy założenie, że wszystkie miesiące mają po 30 dni!
   int Month;
   int Year;

public: 
   // Konstruktor inicjalizujący obiekt dla dnia, miesiąca i roku.
   Date (int InputDay, int InputMonth, int InputYear)
      : Day (InputDay), Month (InputMonth), Year (InputYear) {};

   // Jednoargumentowy operator inkrementacji (prefiks).
   Date& operator ++ ()
   {
      ++Day;
      return *this;
   }

   // Jednoargumentowy operator dekrementacji (prefiks).
   Date& operator -- ()
   {
      --Day;
      return *this; 
   }

   void DisplayDate ()
   {
      cout << Day << " / " << Month << " / " << Year << endl;
   }
};

int main ()
{
   // Utworzenie i inicjalizacja obiektu wraz z datą 25 grudnia 2011 roku.
   Date Holiday (25, 12, 2011);

   cout << "Obiekt został zainicjalizowany z datą: ";
   Holiday.DisplayDate ();

   // Zastosowanie prefiksowego operatora inkrementacji.
   ++ Holiday;

   cout << "Data po zastosowaniu prefiksowego operatora inkrementacji: ";

   // Wyświetlenie daty po inkrementacji.
   Holiday.DisplayDate ();

   -- Holiday;
   -- Holiday;

   cout << "Data po dwukrotnym zastosowaniu prefiksowego operatora dekrementacji: ";
   Holiday.DisplayDate ();

   return 0;
}
