#include <exception>
#include <iostream>
#include <string>
using namespace std;

class CustomException: public std::exception
{
   string Reason;
public:
   // Konstruktor, wymaga Reason.
   CustomException(const char* why):Reason(why) {}

   // Ponowna definicja funkcji wirtualnej, aby zwracała 'Reason'.
   virtual const char* what() const throw()
   {
      return Reason.c_str();
   }
};

double Divide(double Dividend, double Divisor)
{
   if(Divisor == 0)
      throw CustomException("CustomException: Dzielenie przez zero jest zabronione");

   return (Dividend / Divisor);
}

int main()
{
   cout << "Podaj dzielną: ";
   double Dividend = 0;
   cin >> Dividend;
   cout << "Podaj dzielnik: ";
   double Divisor = 0;
   cin >> Divisor;
   try
   {
      cout << "Wynik dzielenia: " << Divide(Dividend, Divisor);
   }
   catch(exception& exp) // Przechwycenie CustomException, bad_alloc itd.
   {
      cout << exp.what() << endl;
      cout << "Przepraszamy, nie można kontynuować pracy!" << endl;
   }

   return 0;
}
