#include <algorithm>
#include <iostream>
#include <vector>
using namespace std;

template <typename elementType>
struct DisplayElementKeepCount
{
    int Count;

    // Konstruktor.
    DisplayElementKeepCount () : Count = 0 {}

    // Wyświetlenie elementu, uaktualnienie wartości licznika!
    void operator () (const elementType& element)
    {
        ++ Count;
        cout << element << ' ';
    }
};

int main ()
{
    vector <int> vecIntegers;
    for (int nCount = 0; nCount < 10; ++ nCount)
        vecIntegers.push_back (nCount);

    cout << " Wyświetlanie obiektu vector przechowującego liczby całkowite: " << endl; 

    // Wyświetlenie tablicy liczb całkowitych.
    DisplayElementKeepCount <int> Result;
    Result = for_each ( vecIntegers.begin ()       // Początek zakresu.
                       , vecIntegers.end ()        // Koniec zakresu.
                       , DisplayElementKeepCount <int> () ); // Obiekt funkcji.

    cout << endl << endl;

    // Użycie informacji o stanie przechowywanej w wartości zwracanej dla każdego for_each!
    cout << "Wyświetlono '" << Result.Count << "' elementów!" << endl;

    return 0;
}
