#include <algorithm>
#include <iostream>
#include <vector>
#include <list>

using namespace std;

// Struktura, która zachowuje się jak funkcja jednoargumentowa.
template <typename elementType>
struct DisplayElement
{
    void operator () (const elementType& element) const
    {
        cout << element << ' ';
    }
};

int main ()
{
    vector <int> vecIntegers;

    for (int nCount = 0; nCount < 10; ++ nCount)
        vecIntegers.push_back (nCount);

    list <char> listChars;

    for (char nChar = 'a'; nChar < 'k'; ++nChar)
        listChars.push_back (nChar);

    cout << "Wyświetlanie obiektu vector przechowującego liczby całkowite: " << endl;

    // Wyświetlanie tablicy liczb całkowitych.
    for_each ( vecIntegers.begin ()    // Początek zakresu.
          , vecIntegers.end ()        // Koniec zakresu.
          , DisplayElement <int> () ); // Obiekt funkcji jednoargumentowej.

    cout << endl << endl;
    cout << "Wyświetlanie obiektu list przechowującego znaki: " << endl;

    // Wyświetlenie znaków.
    for_each ( listChars.begin ()        // Początek zakresu.
          , listChars.end ()        // Koniec zakresu.
          , DisplayElement <char> () ); // Obiekt funkcji jednoargumentowej.

    return 0;
}
