#include <set>

// Poniższego fragmentu kodu można użyć w charakterze parametru wzorca podczas tworzenia egzemplarzy set lub multiset.
template <typename T>
struct SortDescending
{
   bool operator()(const T& lhs, const T& rhs) const
   {
      return (lhs > rhs);
   }
};

int main ()
{
   using namespace std;

   // Proste obiekty set i multiset przechowujące liczby całkowite (używają domyślnego predykatu sortowania).
   set <int> setIntegers1;
   multiset <int> msetIntegers1;

   // Obiekty set i multiset utworzone wraz ze zdefiniowanym przez programistę predykatem sortowania.
   set<int, SortDescending<int> > setIntegers2;
   multiset<int, SortDescending<int> > msetIntegers2;

   // Utworzenie jednego kontenera na podstawie innego lub jego części.
   set<int> setIntegers3(setIntegers1);
   multiset<int> msetIntegers3(setIntegers1.cbegin(), setIntegers1.cend());

   return 0;
}
