#include <algorithm>
#include <vector>
#include <list>
#include <iostream>
using namespace std;

template <typename T>
void DisplayContents (const T& Input)
{
   for(auto iElement = Input.cbegin() // auto i cbegin(): C++11.
      ; iElement != Input.cend()
      ; ++ iElement )
      cout << *iElement << ' ';

   cout << endl;
}

int main ()
{
    // Przykładowy kontener - obiekt vector przechowujący liczby całkowite od -9 do 9.
    vector <int> vecIntegers;
    for (int nNum = -9; nNum < 10; ++ nNum)
        vecIntegers.push_back (nNum);

    // Wstawienie przykładowych wartości do obiektu vector.
    vecIntegers.push_back (9);
    vecIntegers.push_back (9);

    // Inny przykładowy kontener - obiekt list przechowujący liczby całkowite.
    list <int> listIntegers;
    for (int nNum = -4; nNum < 5; ++ nNum)
        listIntegers.push_back (nNum);

    cout << "Zawartość przykładowego obiektu vector to: " << endl;
    DisplayContents(vecIntegers);

    cout << endl << "Zawartość przykładowego obiektu list to: " << endl;
    DisplayContents(listIntegers);

    cout << "Wyszukanie zawartości obiektu 'list' w obiekcie 'vector' za pomocą algorytmu 'search': " << endl;
    auto iRange = search ( vecIntegers.begin () // Początek zakresu.
                  , vecIntegers.end ()      // Koniec przeszukiwanego zakresu.
                  , listIntegers.begin ()  // Początek szukanego zakresu.
                  , listIntegers.end () ); // Koniec szukanego zakresu.

    // Sprawdzenie, czy znaleziono dopasowanie.
    if (iRange != vecIntegers.end ())
    {
        cout << "Sekwencja obiektu list została dopasowana w obiekcie vector w położeniu: ";
        cout << distance (vecIntegers.begin (), iRange) << endl;
    }

    cout << "Wyszukiwanie elementów {9, 9, 9} w obiekcie vector za pomocą algorytmu 'search_n': " << endl;
    auto iPartialRange = search_n ( vecIntegers.begin () // Początek zakresu.
                           , vecIntegers.end ()   // Koniec zakresu.
                           , 3        // Liczba szukanych elementów.
                           , 9 );    // Element do wyszukania.

    if (iPartialRange != vecIntegers.end ())
    {
        cout << "Sekwencja {9, 9, 9} została dopasowana w obiekcie vector w położeniu: ";
        cout << distance (vecIntegers.begin (), iPartialRange) << endl;
    }
    
    return 0;
}
