#include <map>
#include <iostream>
#include <string>
using namespace std;

template <typename T>
void DisplayContents (const T& Input)
{
   for(auto iElement = Input.cbegin() // auto and cbegin(): C++11.
      ; iElement != Input.cend()  // cend() to nowość w C++11.
      ; ++ iElement )
      cout << iElement->first << " -> " << iElement->second << endl;

   cout << endl;
}

int main ()
{
    map<int, string> mapIntToString;

    mapIntToString.insert(make_pair (3, "Trzy"));
    mapIntToString.insert(make_pair (45, "Czterdzieści pięć"));
    mapIntToString.insert(make_pair (-1, "Minus Jeden"));
    mapIntToString.insert(make_pair (1000, "Tysiąc"));

    cout << "Obiekt map zawiera " << mapIntToString.size ();
    cout << " par(ę/(y) klucz-wartość. Elementy w obiekcie map to: " << endl;

    // Wyświetlenie na ekranie zawartości obiektu map.
    DisplayContents(mapIntToString);

   cout << "Podaj klucz, który chcesz znaleźć: ";
   int Key = 0;
   cin >> Key;

   auto iPairFound = mapIntToString.find(Key);
   if (iPairFound != mapIntToString.end())
   {
      cout << "Klucz " << iPairFound->first << " prowadzi do wartości: ";
      cout << iPairFound->second << endl;
   }
   else
      cout << "Przepraszamy, para o kluczu " << Key << " nie istnieje w obiekcie" << endl;

    return 0;
}
