#include <set>
#include <iostream>
#include <string> 
using namespace std;

template <typename T>
void DisplayContents(const T& Input)
{
    for (auto iElement = Input.cbegin() // auto i cbegin() dla C++11.
        ; iElement != Input.cend() // cend() to nowość w C++11.
        ; ++ iElement )
       cout << *iElement << endl; 

    cout << endl;
}

struct ContactItem
{
    string strContactsName;
    string strPhoneNumber; 
    string strDisplayRepresentation;

    // Konstruktor i destruktor.
    ContactItem (const string& strName, const string & strNumber)
    {
        strContactsName = strName;
        strPhoneNumber = strNumber;
        strDisplayRepresentation = (strContactsName + ": " + strPhoneNumber);
    }

    // Operator używany przez std::find(). 
    bool operator == (const ContactItem& itemToCompare) const
    {
        return (itemToCompare.strContactsName == this->strContactsName);
    }

    // Operator używany jako predykat sortowania.. 
    bool operator < (const ContactItem& itemToCompare) const
    {
        return (this->strContactsName < itemToCompare.strContactsName);
    }

   // Operator używany w DisplayContents() za pomocą polecenia cout.
   operator const char*() const
   {
     return strDisplayRepresentation.c_str();
   }
};

int main ()
{
   set<ContactItem> setContacts;
   setContacts.insert(ContactItem("Jack Welsch", "+1 7889 879 879"));
   setContacts.insert(ContactItem("Bill Gates", "+1 97 7897 8799 8"));
   setContacts.insert(ContactItem("Angela Merkel", "+49 23456 5466"));
   setContacts.insert(ContactItem("Vladimir Putin", "+7 6645 4564 797"));
   setContacts.insert(ContactItem("Manmohan Singh", "+91 234 4564 789"));
   setContacts.insert(ContactItem("Barack Obama", "+1 745 641 314"));
   DisplayContents(setContacts);

   cout << "Podaj osobę, której numer telefonu chcesz usunąć: ";
   string NameInput;
   getline(cin, NameInput);

   auto iContactFound = setContacts.find(ContactItem(NameInput, ""));
   if(iContactFound != setContacts.end())
   {
      // Usunięcie elementu znalezionego w kolekcji.
      setContacts.erase(iContactFound);
      cout << "Wyświetlenie zawartości po operacji usunięcia: " << NameInput << endl;
      DisplayContents(setContacts);
   }
   else
      cout << "Nie znaleziono elementu" << endl;

   return 0;
}
