// DemoOperatoraPrzypisania — demonstruje operator przypisania
//                   w klasie zdefiniowanej przez użytkownika
#include <cstdio>
#include <cstdlib>
#include <iostream>
using namespace std;
// DTablica — klasa tablicowa o dynamicznej wielkości
// używana do zademonstrowania operatorów przypisania
// i konstruktora kopiującego
class DTablica
{
  public:
    DTablica(int nDlugoscTablicy = 0)
        : nDlugosc(nDlugoscTablicy), pTablica(nullptr)
    {
        cout << "Tworzenie DTablica długości = "
             << nDlugosc << endl;
        if (nDlugosc > 0)
        {
            pTablica = new int[nDlugosc];
        }
    }
    DTablica(DTablica& da)
    {
        cout << "Kopiowanie DTablica długości = "
             << da.nDlugosc << endl;
        kopiujDTablica(da);
    }
    ~DTablica()
    {
        usunDTablica();
    }
    // operator przypisania
    DTablica& operator=(const DTablica& s)
    {
        cout << "Przypisz źródło o długości = "
             << s.nDlugosc
             << " do celu o długości = "
             << this->nDlugosc << endl;
        // usuń istniejącą tablicę...
        usunDTablica();
        // ...przed podmianą na nową
        kopiujDTablica(s);
        // zwróć referencję do istniejącego obiektu
        return *this;
    }
    int& operator[](int index)
    {
        return pTablica[index];
    }
    int wielkosc() { return nDlugosc; }
    void wyswietl(ostream& out)
    {
        if (nDlugosc > 0)
        {
            out << pTablica[0];
            for(int i = 1; i < nDlugosc; i++)
            {
                out << ", " << pTablica[i];
            }
        }
    }
  protected:
    void kopiujDTablica(const DTablica& da);
    void usunDTablica();
    int nDlugosc;
    int* pTablica;
};
// kopiujDTablica() — utwórz kopię dynamicznej tablicy obiektów klasy int
void DTablica::kopiujDTablica(const DTablica& zrodlo)
{
    nDlugosc = zrodlo.nDlugosc;
    pTablica = nullptr;
    if (nDlugosc > 0)
    {
        pTablica = new int[nDlugosc];
        for(int i = 0; i < nDlugosc; i++)
        {
            pTablica[i] = zrodlo.pTablica[i];
        }
    }
}
// usunDTablica() — zwróć pamięć do sterty
void DTablica::usunDTablica()
{
    nDlugosc = 0;
    delete pTablica;
    pTablica = nullptr;
}
int main(int nLiczbaArgumentow, char* pszArgs[])
{
    // stwórz dynamiczną tablicę i przypisz jej wartości
    DTablica da1(5);
    for (int i = 0; i < da1.wielkosc(); i++)
    {
        // aby uzyskać dostęp do elementów tablicy, użyj
        // operatora indeksu zdefiniowanego przez użytkownika
        da1[i] = i;
    }
    cout << "da1="; da1.wyswietl(cout); cout << endl;
    // teraz utwórz kopię tej dynamicznej tablicy za pomocą
    // konstruktora kopiującego; to samo co da2(da1)
    DTablica da2 = da1;
    da2[2] = 20; // zmień wartość w skopiowanym obiekcie
    cout << "da2="; da2.wyswietl(cout); cout << endl;
    // zastąp istniejący obiekt da2 oryginalnym obiektem da1
    da2 = da1;
    cout << "da2="; da2.wyswietl(cout); cout << endl;
    // aby pozwolić użytkownikowi zobaczyć wynik programu
    // przed zakończeniem programu, poczekaj, aż użytkownik będzie gotowy
    cout << "Naciśnij Enter, aby kontynuować..." << endl;
    cin.ignore(10, '\n');
    cin.get();
    return 0;
}
