// FaktoryzacjaDziedziczeniaWielokrotnego —
// pojedyncza klasa może dziedziczyć
// po więcej niż jednej klasie bazowej
//
#include <cstdio>
#include <cstdlib>
#include <iostream>
#define SPROBUJ_SAM false
using namespace std;
// Mebel - bardziej podstawowe pojęcie;
// ta klasa zawiera składową waga
class Mebel
{
  public:
    Mebel(int w) : waga(w) {}
    int waga;
};
class Lozko : public Mebel
{
  public:
    Lozko(int waga) : Mebel(waga) {}
    void spij(){ cout << "Śpij" << endl; }
};
class Sofa : public Mebel
{
  public:
    Sofa(int waga) : Mebel(waga) {}
    void ogladajTV(){ cout << "Oglądaj telewizję" << endl; }
};
// RozkladanaSofa — jest zarówno klasy Lozko, jak i klasy Sofa
class RozkladanaSofa : public Lozko, public Sofa
{
  public:
    RozkladanaSofa(int waga) : Lozko(waga), Sofa(waga) {}
    void rozloz(){ cout << "Rozłóż" << endl; }
};
int main(int nLiczbaArgumentow, char* pszArgs[])
{
    RozkladanaSofa ss(10);
    // Część 1 —
    // poniższe wywołanie jest niejednoznaczne;
    // czy to Mebel::Sofa czy Mebel::Lozko?
#if SPROBUJ_SAM
    cout << "Waga = " << ss.waga << endl;
#endif
    // Część 2 -
    // kod poniżej jednoznacznie określa ścieżkę
    // dziedziczenia, ale to trochę psuje efekt
    RozkladanaSofa* pSS = &ss;
    Sofa* pSofa = (Sofa*)pSS;
    Mebel* pMebel = (Mebel*)pSofa;
    cout << "Waga = " << pMebel->waga << endl;
    // aby pozwolić użytkownikowi zobaczyć wynik programu
    // przed zakończeniem programu, poczekaj, aż użytkownik będzie gotowy
    cout << "Naciśnij Enter, aby kontynuować..." << endl;
    cin.ignore(10, '\n');
    cin.get();
    return 0;
}
