// KonstruktorKopiujacy — demonstruje konstruktor kopiujący
//
#include <cstdio>
#include <cstdlib>
#include <iostream>
using namespace std;
class Student
{
  public:
    // konwencjonalny konstruktor
    Student(const char *pImie = "no name", int ssId = 0)
      : name(pImie), id(ssId)
    { cout << "Skonstruowano " << name << endl; }
    // konstruktor kopiujący
    Student(const Student& s)
      : name("Kopia " + s.name), id(s.id)
    { cout << "Skonstruowano " << name << endl; }
    ~Student() { cout << "Niszczenie obiektu " << name << endl; }
  protected:
    string name;
    int id;
};
// fn — otrzymuje argument przez wartość
void fn(Student copy)
{
    cout << "Wewnątrz funkcji fn()" << endl;
}
int main(int nLiczbaArgumentow, char* pszArgs[])
{
    Student jacek("Jacek", 1234);
    cout << "Wywołanie funkcji fn()" << endl;
    fn(jacek);
    cout << "Powrót do funkcji main()" << endl;
    // aby pozwolić użytkownikowi zobaczyć wynik programu
    // przed zakończeniem programu, poczekaj, aż użytkownik będzie gotowy
    cout << "Naciśnij Enter, aby kontynuować..." << endl;
    cin.ignore(10, '\n');
    cin.get();
    return 0;
}
