// BUDGET1 - Program przyjmuje depozyty i prośby o wypłaty
//           na różnych numerach rachunków. Na końcu wyświetla
//           podsumowanie utworzonych rachunków.
#include <cstdio>
#include <cstdlib>
#include <iostream>
using namespace std;

// maksymalna liczba rachunków
const int maxAccounts = 10;

// dane rachunków
unsigned accountNumber[maxAccounts];
double   balance[maxAccounts];

// prototypy funkcji
void process(unsigned accountNumber,
             double*  pBalance);
void init(unsigned* pAccountNumber,
          double*   pBalance);

// main - pobierz dane i wyświetl podsumowanie
int main(int nNumberofArgs, char* pszArgs[])
{
   cout << "Wprowadź C aby kontynuować lub X aby zakończyć" << endl;

   int noAccounts = 0;         // liczba kont

   // nie twórz więcej kont, niż dozwolone maksimum
   cout << "Program tworzy rachunki bankowe\n" << endl;
   while (noAccounts < maxAccounts)
   {
       char transactionType;
       cout << "Wprowadź C aby utworzyć kolejne konto"
            << " lub X aby zakończyć:";
       cin  >> transactionType;

       // wyjdź, jeśli wpisano X, lub...
       if (transactionType == 'x' ||
           transactionType == 'X')
       {
           break;
       }

       // jeśli wpisano C...
       if (transactionType == 'c' ||
           transactionType == 'C')
       {
          // zainicjalizuj nowe konto
          // (przekazanie przez referencję, aby funkcja mogła
          // ustawić dla nas wartość)
          init(&accountNumber[noAccounts],
               &balance[noAccounts]);

          // pobierz informacje o transkcjach
          process(accountNumber[noAccounts],
                  &balance[noAccounts]);

          // przesuń indeks na kolejny rachunek
          noAccounts++;
       }
   }

   // wyświetl podsumowanie dla każdego rachunku
   double total = 0;
   cout << "Informacje o rachunku:\n";
   for (int i = 0; i < noAccounts; i++)
   {
      cout << "Saldo dla rachunku "
           << accountNumber[i]
           << " = "
           << balance[i]
           << endl;

      // podsumuj wszystkie konta
      total += balance[i];
   }

   // wyświetl łączną wartość
   cout << "Saldo wszystkich kont = " << total << endl;

   // Aby pozwolić użytkownikowi zobaczyć wyniki programu
   // poczekaj, aż użytkownik będzie gotowy przed zakończeniem programu.
   cout << "Naciśnij Enter, aby kontynuować..." << endl;
   cin.ignore(10, '\n');
   cin.get();

   return 0;
}

// init - inicjalizuje konto pytając o numer rachunku i zerując saldo
//        (wskaźniki)
void init(unsigned* pAccountNumber,
          double*   pBalance)
{
   cout << "Wprowadź numer rachunku:";
   cin  >> *pAccountNumber;
   *pBalance = 0.0;
}

// process - aktualizuje saldo przez odpytanie użytkownika o transakcje
//           (użycie referencji - efekt jak przy wskaźniku)
void process(unsigned accountNumber,
             double*  pBalance)
{
   cout << "Wprowadź wartość dodatnią by wpłacić,\n"
        << "ujemną by wypłacić,\n"
        << " lub zero by zakończyć"
        << endl;

   double transaction;
   while(true)
   {
      cout << ":";
      cin  >> transaction;

      // wyjdź, jeśli zero
      if (transaction == 0)
      {
          break;
      }

      // jeśli wpłata...
      if (transaction > 0)
      {
         // ...dodaj do salda
         *pBalance += transaction;
      }

      // ...w przeciwnym wypadku musi to byc wypłata
      else
      {
         // łatwiej myśleć o wypłacie jak o liczbie dodatniej
         transaction = -transaction;
         if (*pBalance < transaction)
         {
            cout << "Brakuje środków: saldo "
                 << *pBalance
                 << ", wypłata "
                 << transaction
                 << "\n";
         }
         else
         {
            *pBalance -= transaction;
         }
      }
   }
}
