// StringStreamDemo — odczytuje i analizuje zawartość pliku
#include <cstdio>
#include <cstdlib>
#include <fstream>
#include <sstream>
#include <iostream>
using namespace std;
// parsujKonto — odczytaj przekazany bufor tak, jakby
//           był rzeczywistym plikiem — przeczytaj
//           w następującym formacie:
//             imie, saldo konta
//           zwróć wartość true, jeśli wszystko zadziałało dobrze
bool parsujCiag(const char* pCiag,
                char* pImie, int wielkoscTablicy,
                long& numerKonta, double& saldo)
{
    // powiąż obiekt istrstream z
    // wejściowym łańcuchem znaków
    istringstream inp(pCiag);
    // czytaj do separatora przecinków
    inp.getline(pImie, wielkoscTablicy, ',');
    // teraz numer konta
    inp >> numerKonta;
    // oraz saldo
    inp >> saldo;
    // zwróć status błędu
    return !inp.fail();
}
int main(int nLiczbaArguemntow, char* pszArgs[])
{
    // musisz podać nazwę pliku
    char szNazwaPliku[128];
    cout << "Wprowadź nazwę pliku do przeanalizowania:";
    cin.getline(szNazwaPliku, 128);
    // pobierz strumień z pliku
    ifstream* sStrumienDoPliku = new ifstream(szNazwaPliku);
    if (!sStrumienDoPliku->good())
    {
        cerr << "Nie można otworzyć " << pszArgs[1] << endl;
        return 0;
    }
    // odczytaj wiersz z pliku, przeanalizuj go
    // i wyświetl wyniki
    for (int nNumerWiersza = 1;;nNumerWiersza++)
    {
        // przeczytaj bufor
        char bufor[256];
        sStrumienDoPliku->getline(bufor, 256);
        if (sStrumienDoPliku->fail())
        {
            break;
        }
        cout << nNumerWiersza << ":" << bufor << endl;
        // analizuj poszczególne pola
        char imie[80];
        long numerKonta;
        double saldo;
        bool wynik = parsujCiag(bufor, imie, 80,
                                numerKonta, saldo);
        if (wynik == false)
        {
            cerr << "Błąd podczas analizowania łańcucha\n" << endl;
            continue;
        }
        // wyświetl pola, które zostały przeanalizowane
        cout << "Przeczytaj następujące pola:" << endl;
        cout << " imie = " << imie << "\n"
             << " konto = " << numerKonta << "\n"
             << " saldo = " << saldo << endl;
        // umieść pola z powrotem w innej kolejności
        // (wstawienie znaków końca wiersza zapewnia,
        // że bufor jest pusty)
        ostringstream out;
        out << imie << ", "
            << saldo << " "
            << numerKonta << ends;
        string oString = out.str();
        cout << "Zmienione pola: " << oString << endl;
    }
    // aby pozwolić użytkownikowi zobaczyć wynik programu
    // przed zakończeniem programu, poczekaj, aż użytkownik będzie gotowy
    cout << "Naciśnij Enter, aby kontynuować..." << endl;
    cin.ignore(10, '\n');
    cin.get();
    return 0;
}
