// FunctionDemo — demonstruje wykorzystanie
// funkcji poprzez wyłączenie wewnętrznej
// pętli programu NestedDemo
// do oddzielnej funkcji
#include <cstdio>
#include <cstdlib>
#include <iostream>
using namespace std;
// wyswietlWyjasnienie — poinformuj użytkownika
// o regułach programu
void wyswietlWyjasnienie(void)
{
    cout << "Ten program sumuje wiele ciągów liczb.\n"
        << "Zakończ każdą sekwencję, wprowadzając \n"
        << " liczbę ujemną. Zakończ ciąg, \n"
        << "wprowadzając pustą sekwencję\n"
        << endl;
    return;
}
// sumujSekwencje — dodawaj wartości wprowadzane
// przez użytkownika, aż użytkownik wprowadzi
// liczbę ujemną.
// zwróć sumę wprowadzonych liczb
int sumujSekwencje(void)
{
    // pętla „nieskończona”
    int akumulator = 0;
    for(;;)
    {
        // pobierz następną liczbę
        int nWartosc = 0;
        cout << "Wprowadź następną liczbę: ";
        cin >> nWartosc;
        // jeśli jest ujemna…
        if (nWartosc < 0)
        {
            // …wyjdź z pętli
            break;
        }
        // …w przeciwnym razie dodaj liczbę do
        // zmiennej akumulator
        akumulator += nWartosc;
    }
    // zwróć zsumowaną wartość
    return akumulator;
}
int main(int nLiczbaArgumentow, char* pszArgs[])
{
    // wyświetl wyjaśnienie użytkownikowi
    wyswietlWyjasnienie();
    // zsumuj sekwencję liczb…
    for(;;)
    {
        // sumowanie sekwencji liczb
        // wprowadzonych z klawiatury
        cout << "Wprowadź kolejną sekwencję" << endl;
        int zsumowanaWartosc = sumujSekwencje();
        // zakończ pętlę, jeśli wartość zwrócona
        // przez funkcję sumujSekwencje() równa jest 0
        if (zsumowanaWartosc == 0)
        {
            break;
        }
        // wyświetl zsumowaną wartość
        cout << "Suma wynosi " << zsumowanaWartosc
            << endl << endl;
    }
    // aby pozwolić użytkownikowi zobaczyć wynik programu
    // przed zakończeniem programu, poczekaj, aż użytkownik będzie gotowy
    cout << "Naciśnij Enter, aby kontynuować..." << endl;
    cin.ignore(10, '\n');
    cin.get();
    return 0;
}
