//
// BUDGET - Program z klasami Savings (oszczędności)
//          i Checkings (rachunek bieżący)
//
#include <cstdio>
#include <cstdlib>
#include <iostream>
using namespace std;

// maksymalna liczba rachunków
const int MAXACCOUNTS = 10;

// Checking - opisuje rachunek bieżący
class Checking
{
  public:
    Checking(int initializeAN = 0)
         : accountNumber(initializeAN), balance(0.0) {}

    // funkcje dostępowe
    int accountNo() { return accountNumber; }
    double acntBalance() { return balance; }

    // funkcje transakcyjne
    double deposit(double amount)
    {
        balance += amount;
        return balance;
    }
    double withdrawal(double amount);

    // funkcja wyświetlająca stan rachunku
    void display()
    {
        cout << "Rachunek " << accountNumber
             << " = "   << balance
             << endl;
    }

  protected:
    unsigned accountNumber;
    double  balance;
};

//
// withdrawal - zbyt długa funkcja, by była zapisana wprost w klasie
double Checking::withdrawal(double amount)
{
    if (balance < amount)
    {
        cout << "Brakuje środków: saldo " << balance
             << ", wypłata "           << amount
             << endl;
        return false;
    }
    else
    {
        balance -= amount;

        // gdy saldo spada zbyt nisko,...
        if (balance < 500.00)
        {
            // ...pobierz opłatę za utrzymanie rachunku
            balance -= 0.20;
        }
    }
    return true;
}

// Savings - na pewno odgadniesz o co chodzi
class Savings
{
  public:
    Savings(int initialAN = 0)
         : accountNumber(initialAN),
         balance(0.0), noWithdrawals(0) {}

    // funkcje dostępowe
    int accountNo() { return accountNumber; }
    double acntBalance() { return balance; }

    // funkcje transakcyjne
    double deposit(double amount)
    {
        balance += amount;
        return balance;
    }
    bool withdrawal(double amount);

    // funkcja wyświetlająca stan rachunku
    void display()
    {
        cout << "Rachunek "    << accountNumber
             << " = "          << balance
             << " (wypłaty = " << noWithdrawals
             << ")" << endl;
    }
  protected:
    unsigned accountNumber;
    double  balance;
    int   noWithdrawals;
};
bool Savings::withdrawal(double amount)
{
    if (balance < amount)
    {
        cout << "Brak środków: saldo " << balance
             << ", wypłata "           << amount
             << endl;
        return false;
    }
    else
    {
        // dla więcej niż jednej wypłaty w miesiącu...
        if (++noWithdrawals > 1)
        {
            // ...nalicz opłatę
            balance -= 5.00;
        }

        // dokonaj wypłaty
        balance -= amount;
    }
    return true;
}

// prototypy funkcji
void process(Checking* pChecking);
void process(Savings*  pSavings);

// listy rachunków
Checking* chkAcnts[MAXACCOUNTS];
Savings*  svgAcnts[MAXACCOUNTS];

// main - pobierz dane i wyświetl podsumowanie
int main(int argcs, char* pArgs[])
{
    // powtarzaj aż do wpisania 'X' lub 'x'
    int noChkAccounts = 0;  // zliczaj rachunki
    int noSvgAccounts = 0;
    char   accountType;   // S lub C
    while(true)
    {
        cout << "Wprowadź S dla oszczędności, "
             << "C dla rachunków bieżących, "
             << "X by wyjść:";
        cin >> accountType;

        // wyjdź z pętli po wprowadzeniu X/x
        if (accountType == 'x' || accountType == 'X')
        {
            break;
        }

        // postępuj zgodnie z typem rachunku
        switch (accountType)
        {
          // rachunek bieżący
          case 'c':
          case 'C':
            if (noChkAccounts < MAXACCOUNTS)
            {
                int acnt;
                cout << "Wprowadź numer rachunku:";
                cin  >> acnt;
                chkAcnts[noChkAccounts] =
                                     new Checking(acnt);
                process(chkAcnts[noChkAccounts]);
                noChkAccounts++;
            }
            else
            {
                cout << "Brak miejsca na dodatkowe rachunki"
                     << endl;
            }
            break;

          // oszczędności
          case 's':
          case 'S':
            if (noSvgAccounts < MAXACCOUNTS)
            {
                int acnt;
                cout << "Wprowadź numer rachunku:";
                cin  >> acnt;
                svgAcnts[noSvgAccounts] = new Savings(acnt);
                process(svgAcnts[noSvgAccounts]);
                noSvgAccounts++;
            }
            else
            {
                cout << "Brak miejsca na dodatkowe rachunki"
                     << endl;
            }
            break;

          default:
            cout << "Nie zrozumiałem." << endl;
      }
    }

    // wyświetl podsumowanie
    double chkTotal = 0;    // wszystkie rachunki bieżące
    cout << "Rachunki bieżące:\n";
    for (int i = 0; i < noChkAccounts; i++)
    {
        chkAcnts[i]->display();
        chkTotal += chkAcnts[i]->acntBalance();
    }

    double svgTotal = 0;    // wszystkie rachunki oszczędnościowe
    cout << "Rachunki oszczędnościowe:\n";
    for (int j = 0; j < noSvgAccounts; j++)
    {
        svgAcnts[j]->display();
        svgTotal += svgAcnts[j]->acntBalance();
    }

    double total = chkTotal + svgTotal;
    cout << "Suma na rachunkach bieżących = "
         << chkTotal
         << endl;

    cout << "Suma na rachunkach oszczędnościowych = "
         << svgTotal
         << endl;

    cout << "Suma łącznie         = "
         << total
         << endl;

    // Aby pozwolić użytkownikowi zobaczyć wyniki programu
    // poczekaj, aż użytkownik będzie gotowy przed zakończeniem programu.
    cout << "Naciśnij Enter, aby kontynuować..." << endl;
    cin.ignore(10, '\n');
    cin.get();

    return 0;
}

// process(Checking) - wprowadź dane dla rachunków zwykłych
void process(Checking* pChecking)
{
    cout << "Wprowadź wartość dodatnią by wpłacić,\n"
         << "ujemną by wypłacić,\n"
         << " lub zero by zakończyć"
         << endl;

    double transaction;
    while(true)
    {
        cout << ":";
        cin >> transaction;
        if (transaction == 0)
        {
            break;
        }

        // wpłać
        if (transaction > 0)
        {
          pChecking->deposit(transaction);
        }

        // wypłać
        if (transaction < 0)
        {
          pChecking->withdrawal(-transaction);
        }
    }
}

// process(Savings) - wprowadź dane dla rachunków oszczędnościowych
void process(Savings* pSavings)
{
    cout << "Wprowadź wartość dodatnią by wpłacić,\n"
         << "ujemną by wypłacić,\n"
         << " lub zero by zakończyć"
         << endl;

    double transaction;
    while(true)
    {
        cout << ":";
        cin >> transaction;
        if (transaction == 0)
        {
            break;
        }

        // wpłać
        if (transaction > 0)
        {
          pSavings->deposit(transaction);
        }

        // wypłać
        if (transaction < 0)
        {
          pSavings->withdrawal(-transaction);
        }
    }
}
